#!/bin/bash

source ../../dmp_env.sh

date_path=$(date +"%Y/%m/%d" -d "-1 day ${ScheduleTime}")

date=$(date +%Y%m%d -d "-1 day ${ScheduleTime}")

# keyspace name
keyspace="mapping"

# table name
table="mapping_server"

output="${BACKFLOW_OUTPUT}/${keyspace}/${table}_filter/${date_path}"

spark-submit --class mobvista.dmp.datasource.backflow.BackFlowFilter \
  --name "BackFlowFilter.${keyspace}.${table}" \
  --conf spark.sql.shuffle.partitions=2000 \
  --conf spark.default.parallelism=2000 \
  --conf spark.kryoserializer.buffer.max=512m \
  --conf spark.kryoserializer.buffer=64m \
  --master yarn --deploy-mode cluster \
  --executor-memory 4g --driver-memory 4g --executor-cores 2 --num-executors 20 \
  ../.././DMP.jar \
  -output ${output} -date ${date}

if [[ $? -ne 0 ]]; then
  exit 255
fi
