#!/bin/bash

source ../../dmp_env.sh

# package name
system="mapping"

# keyspace name
keyspace="mapping"

# table name
table="mapping_server"

date_path=$(date +"%Y/%m/%d" -d "-1 day ${ScheduleTime}")

# 备份 s3 地址
input="${BACKFLOW_OUTPUT}/${keyspace}/${table}/${date_path}/${region}/"

spark-submit --class mobvista.dmp.datasource.backflow.BackWrite \
  --name "BackWrite.${keyspace}.${table}.${region}" \
  --conf spark.sql.shuffle.partitions=2000 \
  --conf spark.default.parallelism=2000 \
  --conf spark.kryoserializer.buffer.max=512m \
  --conf spark.kryoserializer.buffer=64m \
  --master yarn --deploy-mode cluster \
  --executor-memory 4g --driver-memory 4g --executor-cores 2 --num-executors 4 \
  ../.././DMP.jar \
  -keyspace ${keyspace} -table ${table} -region ${region} -input ${input} -system ${system}

if [[ $? -ne 0 ]]; then
  exit 255
fi
