#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :adn_trackingnew_merge_daily.sh
# @author  :wangjf
# @revision:2019-11-26 11:22:36
# # # # # # # # # # # # # # # # # # # # # #

source ../../dmp_env.sh

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")
expire_date=$(date +%Y%m%d -d "-4 day $today")
expire_date_path=$(date +%Y/%m/%d -d "-4 day $today")

EVENT_INFO_PATH="s3://mob-emr-test/dataplatform/DataWareHouse/data/dev/event_info/${date_path}"
check_await "${EVENT_INFO_PATH}/_SUCCESS"

sleep 60

output_path="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/etl_tracking_adn_merge_daily/${date_path}"

spark-submit --class mobvista.dmp.datasource.datatory.AdnTrackingMergeDaily \
     --conf spark.sql.shuffle.partitions=100 \
     --conf spark.default.parallelism=100 \
     --conf spark.sql.files.maxPartitionBytes=536870912 \
     --files ${HIVE_SITE_PATH} \
     --jars ${JARS} \
     --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 6g  --executor-cores 3  --num-executors 5 \
     ../../${JAR} -date ${date} -output ${output_path}

if [[ $? -ne 0 ]]; then
    exit 255
fi

# 挂载分区
mount_partition "etl_tracking_adn_merge_daily" "dt='${date}'" "${output_path}"