#!/usr/bin/env bash

source ../dmp_env.sh

date=$(date +"%Y%m%d" -d "-1 day $ScheduleTime")
date_path=$(date +%Y/%m/%d -d "-1 day $ScheduleTime")
expire_date=$(date +%Y%m%d -d "-31 day $ScheduleTime")
expire_date_path=$(date +%Y/%m/%d -d "-31 day $ScheduleTime")

ADN_INSTALL_INPUT="${DM_DEVICE_TAG_DAILY_PATH}/${date_path}/manual/adn_install"
ADN_REQUEST_INPUT="${DM_DEVICE_TAG_DAILY_PATH}/${date_path}/manual/adn_request_sdk"
ADN_REQUEST_OTHER_INPUT="${DM_DEVICE_TAG_DAILY_PATH}/${date_path}/manual/adn_request_other"
ADN_SDK_INPUT="${DM_DEVICE_TAG_DAILY_PATH}/${date_path}/manual/adn_sdk"
DSP_REQUEST_INPUT="${DM_DEVICE_TAG_DAILY_PATH}/${date_path}/manual/dsp_req"
SSS_INPUT="${DM_DEVICE_TAG_DAILY_PATH}/${date_path}/manual/3s"
MP_INPUT="${DM_DEVICE_TAG_DAILY_PATH}/${date_path}/manual/mp"
CLEVER_INPUT="${DM_DEVICE_TAG_DAILY_PATH}/${date_path}/manual/clever"
JOYPAC_INPUT="${DM_DEVICE_TAG_DAILY_PATH}/${date_path}/manual/joypacios"
BYTEDANCE_INPUT="${DM_DEVICE_TAG_DAILY_PATH}/${date_path}/manual/bytedance"
FACEBOOK_INPUT="${DM_DEVICE_TAG_DAILY_PATH}/${date_path}/manual/facebook"
GA_INPUT="${DM_DEVICE_TAG_DAILY_PATH}/${date_path}/manual/ga"
check_await ${ADN_INSTALL_INPUT}/_SUCCESS
check_await ${ADN_REQUEST_INPUT}/_SUCCESS
check_await ${ADN_REQUEST_OTHER_INPUT}/_SUCCESS
check_await ${ADN_SDK_INPUT}/_SUCCESS
check_await ${DSP_REQUEST_INPUT}/_SUCCESS
check_await ${SSS_INPUT}/_SUCCESS
check_await ${MP_INPUT}/_SUCCESS
check_await ${CLEVER_INPUT}/_SUCCESS
check_await ${JOYPAC_INPUT}/_SUCCESS
check_await ${BYTEDANCE_INPUT}/_SUCCESS
check_await ${FACEBOOK_INPUT}/_SUCCESS
check_await ${GA_INPUT}/_SUCCESS

USER_INFO_3S_INPUT="${ODS_DMP_USER_INFO}/${date_path}/3s"
USER_INFO_DSP_INPUT="${ODS_DMP_USER_INFO}/${date_path}/dsp_req"
USER_INFO_ADN_REQUEST_INPUT="${ODS_DMP_USER_INFO}/${date_path}/adn_request"
USER_INFO_BYTEDANCE_INPUT="${ODS_DMP_USER_INFO}/${date_path}/bytedance"
USER_INFO_JOYPAC_INPUT="${ODS_DMP_USER_INFO}/${date_path}/joypacios"
USER_INFO_FACEBOOK_INPUT="${ODS_DMP_USER_INFO}/${date_path}/facebook"
USER_INFO_GA_INPUT="${ODS_DMP_USER_INFO}/${date_path}/ga"
check_await ${USER_INFO_3S_INPUT}/_SUCCESS
check_await ${USER_INFO_DSP_INPUT}/_SUCCESS
check_await ${USER_INFO_ADN_REQUEST_INPUT}/_SUCCESS
check_await ${USER_INFO_BYTEDANCE_INPUT}/_SUCCESS
check_await ${USER_INFO_JOYPAC_INPUT}/_SUCCESS
check_await ${USER_INFO_FACEBOOK_INPUT}/_SUCCESS
check_await ${USER_INFO_GA_INPUT}/_SUCCESS

DEVICE_REGION_INPUT="${DM_DEVICE_REGION}/${date_path}"
check_await ${DEVICE_REGION_INPUT}/_SUCCESS

part='month'

OUTPUT_PATH="${DM_ACTIVE_TAG_PATH}/${date_path}/${part}"

EXPIRE_OUTPUT_PATH="${DM_ACTIVE_TAG_PATH}/${expire_date_path}/${part}"

spark-submit --class mobvista.dmp.datasource.dm.ActiveTag \
     --name "mobvista.dmp.datasource.dm.ActiveTag_month_wangjf_${date}" \
     --conf spark.sql.shuffle.partitions=10000 \
     --conf spark.default.parallelism=1000 \
     --conf spark.yarn.executor.memoryOverhead=2048 \
     --conf spark.sql.files.maxPartitionBytes=268435456 \
     --conf spark.sql.adaptive.enabled=true \
     --conf spark.sql.adaptive.advisoryPartitionSizeInBytes=268435456 \
     --files ${HIVE_SITE_PATH} \
     --jars ${JARS} \
     --master yarn --deploy-mode cluster --executor-memory 18g --driver-memory 4g  --executor-cores 5  --num-executors 60 \
     ../${JAR} \
     -date ${date} -output ${OUTPUT_PATH} -coalesce 1000 -days 29

if [[ $? -ne 0 ]]; then
    exit 255
fi

# 挂载分区
mount_partition "dm_active_tag" "dt='${date}',part='${part}'" "${OUTPUT_PATH}"

# 删除过期的分区及删除对应路径
unmount_partition "dm_active_tag" "dt='${expire_date}',part='${part}'" "${EXPIRE_OUTPUT_PATH}"