#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    : fix_dmp_install_list.sh
# @author  : jinfeng.wang
# @time    : 2020-05-22 16:06:07
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=${ScheduleTime:-$1}
date=$(date +%Y%m%d -d "-1 day $LOG_TIME")
date_path=$(date +"%Y/%m/%d" -d "-1 day ${LOG_TIME}")

BUSINESS="dsp_req"

OUTPUT_PATH="${DMP_INSTALL_LIST}/2020/12/26/${BUSINESS}"

spark-submit --class mobvista.dmp.datasource.dm.FixDmpInstallList \
    --name "FixDmpInstallList.${date}"\
    --conf spark.sql.shuffle.partitions=15000 \
    --conf spark.default.parallelism=2000 \
    --conf spark.kryoserializer.buffer.max=512m \
    --conf spark.kryoserializer.buffer=64m \
    --conf spark.sql.adaptive.enabled=true \
    --conf spark.sql.adaptive.advisoryPartitionSizeInBytes=536870912 \
    --files ${HIVE_SITE_PATH} \
    --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 4g --executor-cores 5 --num-executors 100 \
    ../${JAR} \
    -date ${date} -coalesce 4000 -output $OUTPUT_PATH -business ${BUSINESS}

if [[ $? -ne 0 ]]; then
    exit 255
fi