#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : dsp_gender_tag.sh
# @author: walt
# @date  : 16-12-04
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

YESTERDAY=$(date -d "$ScheduleTime 2 days ago" "+%Y%m%d")
old_year=${YESTERDAY:0:4}
old_month=${YESTERDAY:4:2}
old_day=${YESTERDAY:6:2}

INPUT_DSP_PROFILE_PATH="$ETL_DSP_REQ_DAILY/$year/$month/$day"
INPUT_DSP_TOTAL_PATH="$DMP_ADN_DSP_PROFILE_TOTAL/$old_year/$old_month/$old_day"
OUTPUT_PATH="$DMP_ADN_DSP_PROFILE_TOTAL/$year/$month/$day"

hadoop fs -rm -r ${OUTPUT_PATH}/*
check_await "${INPUT_DSP_TOTAL_PATH}/_SUCCESS"
REDUCE_NUM=$(calculate_reduce_num ${INPUT_DSP_TOTAL_PATH})

hadoop jar ../${JAR} mobvista.dmp.datasource.dsp.mapreduce.DspDeviceProfileTotalMR \
    -Dtask.date="$year-$month-$day" \
    -Dmapreduce.map.memory.mb=4096 \
    -Dmapreduce.map.java.opts=-Xmx2458m \
    -Dmapreduce.reduce.memory.mb=4096 \
    -Dmapreduce.reduce.java.opts=-Xmx2458m \
    -Dmapreduce.job.reduces=${REDUCE_NUM} \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "$INPUT_DSP_PROFILE_PATH" "$INPUT_DSP_TOTAL_PATH"  "$OUTPUT_PATH" || exit 1

mount_partition "dm_profile_total" "type='dsp', year='$year', month='$month', day='$day' " "$OUTPUT_PATH"

echo "[Adn_Dsp profile Total Tag End!]"


