#!/bin/sh

source ../../dmp_env.sh


ScheduleTime=${ScheduleTime:-$1}
starttime=$(date -d "4 hours ago $ScheduleTime" "+%Y%m%d%H")
endtime=$(date -d "1 hours ago $ScheduleTime" "+%Y%m%d%H")

datapath=$(date -d "1 hours ago $ScheduleTime" "+%Y/%m/%d")
yearpath=$(date -d "1 hours ago $ScheduleTime" "+%Y")
mothpath=$(date -d "1 hours ago $ScheduleTime" "+%m")
daypath=$(date -d "1 hours ago $ScheduleTime" "+%d")
hhpath=$(date -d "1 hours ago $ScheduleTime" "+%H")


dsp_impression_tokyo_hour="s3://mob-ad/adn/dsp/impression_org/impression/${datapath}/tokyo/${hhpath}"

dsp_request_orc_hour_tokyo="s3://mob-ad/adn/dsp_orc/bid_request/${datapath}/tokyo/${hhpath}"


check_await "${dsp_impression_tokyo_hour}/_SUCCESS"
check_await "${dsp_request_orc_hour_tokyo}/_SUCCESS"

common_mount_partition "adn_dsp" "log_adn_dsp_impression_org_hour" "yr='${yearpath}', mt='${mothpath}',dt='${daypath}',rg='tokyo',hh='${hhpath}'" "${dsp_impression_tokyo_hour}"

common_mount_partition "adn_dsp" "log_adn_dsp_bid_request_orc_hour" "yr='${yearpath}', mt='${mothpath}',dt='${daypath}',rg='tokyo',hh='${hhpath}'" "${dsp_request_orc_hour_tokyo}"


## TOYKOOUTPUT_PATH=s3://mob-emr-test/andy/log_adn_dsp_impression_hour_test/${datapath}/tokyo/${hhpath}

TOYKOOUTPUT_PATH=s3://mob-ad/adn/dsp/impression/${datapath}/tokyo/${hhpath}


hadoop fs -test -e ${TOYKOOUTPUT_PATH}
if [ $? -ne 0 ];then
hadoop fs -mkdir -p  ${TOYKOOUTPUT_PATH}
fi

hadoop fs -rmr ${TOYKOOUTPUT_PATH}

spark-submit --class  mobvista.dmp.datasource.dsp.DspImpressionHourFullOther \
     --name "mobvista.dmp.datasource.dsp.DspImpressionHourFullOther.tokyo" \
	--conf spark.sql.shuffle.partitions=2000 \
	--conf spark.default.parallelism=2000 \
	--conf spark.serializer=org.apache.spark.serializer.KryoSerializer \
	--conf spark.yarn.executor.memoryOverhead=2048 \
	--files ${HIVE_SITE_PATH} \
	--master yarn \
	--deploy-mode cluster \
	--executor-memory 6G \
	--driver-memory 3G \
	--executor-cores 3 \
	--num-executors 10 \
	../../${JAR}  \
	-starttime ${starttime}  -endtime ${endtime} -output ${TOYKOOUTPUT_PATH} -region tokyo

if [ $? -ne 0 ]; then
    exit 255
fi

common_mount_partition "adn_dsp" "log_adn_dsp_impression_hour" "yr='${yearpath}', mt='${mothpath}',dt='${daypath}',rg='tokyo',hh='${hhpath}'" "${TOYKOOUTPUT_PATH}"

hadoop fs -touchz ${TOYKOOUTPUT_PATH}/_SUCCESS

