#!/usr/bin/env bash

source ../dmp_env.sh

today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")

echo ${today}
echo ${yesterday}


TP_TOTAL_PATH_YES="${BEHAVIOR_TP_TOTAL}/${yesterday}"
OUTPUT_TOTAL_PATH="${BEHAVIOR_TP_TOTAL}/${today}"

DMP_EVENT_TAG_PATH="${DMP_EVENT_TAG_DAILY}/day=${dt_today}/tag_source=tp/tag_type=other_purchase"


check_await "${TP_TOTAL_PATH_YES}/_SUCCESS"


hadoop fs -rm -r "${OUTPUT_TOTAL_PATH}/"
hadoop fs -rm -r "${DMP_EVENT_TAG_PATH}/"


spark-submit --class mobvista.dmp.datasource.behavior.ThirdPartySourceTotal \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=10 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --files ${HIVE_SITE_PATH} \
 --jars s3://mob-emr-test/dataplatform/DataWareHouse/offline/myjar/hive-hcatalog-core-2.3.3.jar \
 --master yarn --deploy-mode cluster --name behavior_from_third_party_total --executor-memory 2g --driver-memory 4g  --executor-cores 2  --num-executors 2 \
 ../${JAR}  -outputtotal ${OUTPUT_TOTAL_PATH} -dmpevent ${DMP_EVENT_TAG_PATH} -coalesce 10  \
 -yesterday ${dt_yesterday}

if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "etl_behavior_thirdparty_data_total" "dt='${dt_today}'" "${OUTPUT_TOTAL_PATH}"
mount_partition "dmp_event_tag_daily" "day='${dt_today}',tag_source='tp',tag_type='other_purchase'" "${DMP_EVENT_TAG_PATH}"

hadoop fs -touchz ${OUTPUT_TOTAL_PATH}/_SUCCESS
hadoop fs -touchz ${DMP_EVENT_TAG_PATH}/_SUCCESS