#!/usr/bin/env bash

source ../dmp_env.sh

today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
umount_time=$(date -d "$ScheduleTime 5 days ago" +"%Y%m%d")
umount_date_path=$(date -d "$ScheduleTime 5 days ago" +"%Y/%m/%d")

echo ${today}
echo ${yesterday}


INPUT_PATH="${FACEBOOK_DAILY_PATH}/${today}"
FB_TOTAL_PATH_YES="${FACEBOOK_TOTAL_PATH}/${yesterday}"

OUTPUT_TOTAL_PATH="${FACEBOOK_TOTAL_PATH}/${today}"
UMOUNT_OUTPUT_TOTAL_PATH="${FACEBOOK_TOTAL_PATH}/${umount_date_path}"

GENDER_OUTPUT_PATH="${GENDER_GET_FACEBOOK_PATH}/${today}"
UMOUNT_GENDER_OUTPUT_PATH="${GENDER_GET_FACEBOOK_PATH}/${umount_date_path}"



check_await "${INPUT_PATH}/_SUCCESS"
check_await "${FB_TOTAL_PATH_YES}/_SUCCESS"

mount_partition "etl_facebook_daily" "dt='${dt_today}'" "$INPUT_PATH"


hadoop fs -rm -r "${OUTPUT_TOTAL_PATH}/"
hadoop fs -rm -r "${GENDER_OUTPUT_PATH}/"

spark-submit --class mobvista.dmp.datasource.facebook.FaceBookTotal \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=10 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --files ${HIVE_SITE_PATH} \
 --jars s3://mob-emr-test/dataplatform/DataWareHouse/offline/myjar/hive-hcatalog-core-2.3.3.jar \
 --master yarn --deploy-mode cluster --name facebook_device_total --executor-memory 2g --driver-memory 2g  --executor-cores 2  --num-executors 3 \
 ../${JAR}  -outputtotal ${OUTPUT_TOTAL_PATH} -outputgender ${GENDER_OUTPUT_PATH} -coalesce 10 \
 -today ${dt_today} -yesterday ${dt_yesterday}


if [ $? -ne 0 ];then
  exit 255
fi



mount_partition "etl_facebook_total" "dt='${dt_today}'" "${OUTPUT_TOTAL_PATH}"
unmount_partition "etl_facebook_total" "dt='${umount_time}'" "${UMOUNT_OUTPUT_TOTAL_PATH}"

mount_partition "ods_gender_fb" "dt='${dt_today}'" "${GENDER_OUTPUT_PATH}"
unmount_partition "ods_gender_fb" "dt='${umount_time}'" "${UMOUNT_GENDER_OUTPUT_PATH}"

hadoop fs -touchz ${GENDER_OUTPUT_PATH}/_SUCCESS
hadoop fs -touchz ${OUTPUT_TOTAL_PATH}/_SUCCESS