#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :fmp_report.sh
# @desc    :fmp_report job
# # # # # # # # # # # # # # # # # # # # # #

dt=$(date +%Y-%m-%d -d "-1 days $ScheduleTime")

file="fmp_report_${dt}.xls"
if [[ -f "$file" ]]; then
     rm -rf ${file}
fi

mysql -h dataplatform-app-tag.c5yzcdreb1xr.us-east-1.rds.amazonaws.com -P 3306 -u apptag_rw -p7gyLEVtkER3u8c9 -e "SELECT day AS 'date',user_id,COUNT(1) AS 'count',SUM(return_num) AS 'device_num' FROM (SELECT user_id,CASE WHEN return_data_num <= \`limit\` THEN return_data_num ELSE \`limit\` END AS return_num,date_format(update_time,'%Y-%m-%d') day FROM dmp_fmp.job_profile WHERE flag = 1 AND date_format(update_time,'%Y-%m-%d') = '${dt}') t GROUP BY day, user_id" >${file}

if [[ $? -ne 0 ]]; then
    exit 255
fi

# mingyuan.ren@mobvista.com,young.chao@mintegral.com
python2.7 ../python/sendMail.py -t 'mingyuan.ren@mobvista.com,young.chao@mintegral.com'  -c 'jinfeng.wang@mobvista.com' -s "FMP 查询数据报表_$dt" -b "Hi，明远<br/><br/>&nbsp;&nbsp;&nbsp;&nbsp;FMP 查询数据报表见附件<br/><br/>" -a ./${file}
if [[ $? -ne 0 ]]; then
    exit 255
fi

rm -rf ${file}