#! /bin/bash


# # # # # # # # # # # # # # # # # # # # # #
# @file    :extract_device.sh
# @author  :liushuai
# @revision:2017-01-18 16:52
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}


INPUT_PATH="${GENDER_MERGE_INSTALL}/${year}/${month}/${day}/"
OUTPUT_PATH="${GENDER_CALC_PACKAGE}/${year}/${month}/${day}/"

NUM_REDUCES=$(calculate_reduce_num ${INPUT_PATH})

hadoop fs -rm -r ${OUTPUT_PATH}
hadoop jar ../${JAR} mobvista.dmp.datasource.gender.CalcPackageGenderMR \
    -Dmapreduce.job.reduces=${NUM_REDUCES} \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    "${INPUT_PATH}" "${OUTPUT_PATH}"  || exit 1

if [ $? -ne 0 ]; then
    exit 255
fi