#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# @date : 2019-02-27 11:24:06
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt=$(date -d "$ScheduleTime 1 days ago" +"%Y-%m-%d")

date_path=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

DICT_PATH="s3://mob-emr-test/dataplatform/dict/joypac_package.txt"

OUTPUT_PATH="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/joypac_result_daily/${date_path}"

cluster="cluster_1st"

spark-submit --class mobvista.dmp.datasource.joypac.JoypacResultDaily \
    --conf spark.yarn.executor.memoryOverhead=2048  \
    --conf spark.network.timeout=720s \
    --conf spark.default.parallelism=20 \
    --master yarn --deploy-mode cluster --name JoypacResutlDaily \
    --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 5 \
    --files ${HIVE_SITE_PATH} \
    --jars ${JARS} \
    ../${JAR} -dict ${DICT_PATH} -output ${OUTPUT_PATH} -coalesce 10 -date ${LOG_TIME} -cluster ${cluster}

if [[ $? -ne 0 ]];then
  exit 255
fi

echo