#!/bin/bash

source ../dmp_env.sh

today=${ScheduleTime:-$1}

datetime=$(date +"%Y%m%d%H" -d "-1 hour $today")

spark-submit --class mobvista.dmp.datasource.rtdmp.AudienceInfoWrite \
     --name "AudienceInfoWrite.${date}" \
     --conf spark.sql.shuffle.partitions=2000 \
     --conf spark.default.parallelism=2000 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --master yarn --deploy-mode cluster --executor-memory 6g --driver-memory 4g  --executor-cores 4  --num-executors 15 \
     ../${JAR} -datetime ${datetime}

if [[ $? -ne 0 ]]; then
    exit 255
fi