#!/bin/bash

source ../dmp_env.sh

part=$1

today=${ScheduleTime:-$2}

date=$(date +"%Y%m%d" -d "-1 day $today")

date_path=$(date +%Y/%m/%d -d "-1 day $today")

checkRTDmp ${today}

INPUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dev/device_info_daily/${date_path}/part-0${part}*"

spark-submit --class mobvista.dmp.datasource.rtdmp.DeviceInfoWrite \
     --name "DeviceInfoWrite.${date}" \
     --conf spark.sql.shuffle.partitions=10000 \
     --conf spark.default.parallelism=10000 \
     --conf spark.kryoserializer.buffer.max=256m \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 4  --num-executors 5 \
     ../${JAR} -input ${INPUT}

if [[ $? -ne 0 ]]; then
    exit 255
fi