CREATE EXTERNAL TABLE `dm_profile_total`(
  `device_id` string COMMENT 'from deserializer',
  `device_type` string COMMENT 'from deserializer',
  `platform` string COMMENT 'from deserializer',
  `time` string COMMENT 'from deserializer',
  `ip` string COMMENT 'from deserializer',
  `maker` string COMMENT 'from deserializer',
  `model` string COMMENT 'from deserializer',
  `os` string COMMENT 'from deserializer',
  `os_v` string COMMENT 'from deserializer',
  `country` string COMMENT 'from deserializer',
  `birthday` string COMMENT 'from deserializer',
  `gender` string COMMENT 'from deserializer',
  `dmp_time` string COMMENT 'from deserializer')
PARTITIONED BY (
  `type` string,
  `year` string,
  `month` string,
  `day` string)
ROW FORMAT SERDE
  'org.openx.data.jsonserde.JsonSerDe'
STORED AS INPUTFORMAT
  'org.apache.hadoop.mapred.TextInputFormat'
OUTPUTFORMAT
  'org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat'
LOCATION
  's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_profile_total'