#!/usr/bin/env bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :count_dsp_m_daily.sh
# @author  :liushuai
# @revision:2017-05-18 14:45
# @desc    ：分国家统计M系统与dsp日志量
# # # # # # # # # # # # # # # # # # # # # #

LOG_TIME=$(date +%Y%m%d -d "-8 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

source ../prd_env.sh

INPUT_DSP="${REQUEST_TMP_PATH}/merge_dsp_3_day/${year}/${month}/${day}/"
INPUT_M="${REQUEST_TMP_PATH}/etl_adn_sdk_req_3_day/${year}/${month}/${day}/"
OUTPUT="${REQUEST_TMP_PATH}/count_country_dsp_m_3_day/${year}/${month}/${day}/"


hadoop fs -rmr ${OUTPUT}

hadoop jar ../${JAR} mobvista.prd.datasource.source.mapreduce.CountDspMCountryMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    -Dmapreduce.job.reduces=1 \
    ${INPUT_DSP} ${INPUT_M} ${OUTPUT}

if [ $? -ne 0 ];then
  exit 255
fi
