package mobvista.dmp.datasource.adn.mapreduce;

import mobvista.dmp.util.MRUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

import java.io.IOException;
import java.util.regex.Pattern;

/**
 * Created by Administrator on 2017/6/12 0012.
 */
public class AdnClickDailyMR {
    public static void main(String[] args) {
        int exitCode = 0;
        try {
            Configuration conf = new Configuration();
            conf.set("mapreduce.map.speculative", "true");
            conf.set("mapreduce.reduce.speculative", "true");
            conf.set("mapreduce.task.io.sort.mb", "500");
            conf.set("mapreduce.reduce.java.opts", "-Xmx1536m");
            conf.set("mapreduce.reduce.memory.mb", "2048");
            conf.set("mapreduce.reduce.shuffle.parallelcopies", "50");
            String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();

            Job job = Job.getInstance(conf, "AdnClickDailyMR");
            job.setJarByClass(AdnClickDailyMR.class);
            job.setNumReduceTasks(10);

            FileOutputFormat.setCompressOutput(job, true);
            FileOutputFormat.setOutputCompressorClass(job, GzipCodec.class);

            job.setMapperClass(AdnClickDailyMapper.class);

            job.setOutputKeyClass(Text.class);
            job.setOutputValueClass(NullWritable.class);

            FileInputFormat.addInputPath(job, new Path(otherArgs[0]));
            FileOutputFormat.setOutputPath(job, new Path(otherArgs[1]));

            exitCode = job.waitForCompletion(true) ? 0 : 1;
        } catch (Exception e) {
            exitCode = -1;
            e.printStackTrace();
        } finally {
            System.exit(exitCode);
        }
    }

    public static class AdnClickDailyMapper extends Mapper<LongWritable, Text, Text, NullWritable> {
        private Pattern idPtn = Pattern.compile("0*-0*-0*-0*-0*");
        private static Pattern splitPtn = Pattern.compile("-");
        private final Text outKey = new Text();

        public void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException {

            String line = value.toString();
            String[] array = MRUtils.SPLITTER.split(line, -1);
            if (array.length > 44) {
                String requestId = array[33];
                String campaignId = array[7];
                String gaid = array[42];
                String idfa = array[43];
                String platform = array[13];
                if (requestId.equals("0") || campaignId.length() < 2) {
                    return;
                }
                String extSysid = "";
                if (array.length >= 118) {
                    extSysid = array[117];
                }
                String devIdType = GetDevIdUtil.getIdByIdAndPlatform(gaid, idfa, extSysid, platform);
                if (StringUtils.isNotBlank(devIdType)) {
                    outKey.set(MRUtils.JOINER.join(devIdType, requestId, campaignId, platform));
                    context.write(outKey, NullWritable.get());
                }
                /*
                if (!idPtn.matcher(gaid).matches() && splitPtn.split(gaid).length == 5) {
                    outKey.set(MRUtils.JOINER.join(gaid, "gaid", requestId, campaignId, paltform));
                    context.write(outKey, NullWritable.get());
                }
                if (!idPtn.matcher(idfa).matches() && splitPtn.split(idfa).length == 5) {
                    outKey.set(MRUtils.JOINER.join(idfa, "idfa", requestId, campaignId, paltform));
                    context.write(outKey, NullWritable.get());
                }
                 */
            } else {
                context.getCounter("DMP", "col_num_error").increment(1L);
            }

        }
    }
}
