package mobvista.dmp.datasource.apptag.crawler;

import mobvista.dmp.util.HttpUtil;

import java.io.IOException;

/**
 * author: houying
 * date  : 16-11-3
 * desc  :
 */
public class IosDetailVisitor implements AppInfoCrawler.DetailVisitor {

    private final String lookupUrl = "https://itunes.apple.com/lookup?id=%s&country=US";
    private final ProxyManager proxyManager;

    public IosDetailVisitor(ProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    @Override
    public HttpUtil.HttpResult visit(String packageName) throws IOException {
        if (packageName.startsWith("id")) {
            packageName = packageName.substring(2);
        }
        return HttpUtil.doGet(String.format(lookupUrl, packageName), proxyManager.getProxy());
    }
}
