package mobvista.dmp.datasource.eggplants;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import mobvista.dmp.util.HttpUtil;
import mobvista.dmp.util.MRUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;

import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

/**
 * author: houying
 * date  : 17-3-15
 * desc  :
 */
public class CatchThread implements Runnable {

    private final String packageList;
    private BlockingQueue<String> input;
    private BlockingQueue<String> output;
    private volatile boolean stop;

    public CatchThread(BlockingQueue<String> output, String packageList) {
        this.output = output;
        this.input = new ArrayBlockingQueue<String>(10);
        this.packageList = packageList;
        this.stop = false;
    }

    public void push(String line) throws InterruptedException {
        input.put(line);
    }
    @Override
    public void run() {
        int handleNum = 0;
        int writeNum = 0;
        ObjectMapper objectMapper = new ObjectMapper();
        JavaType mapType = objectMapper.getTypeFactory().constructMapType(HashMap.class, String.class, String.class);
        while(true) {
            if (stop && input.isEmpty()) {
                break;
            }
            try {
                String line = input.poll(1, TimeUnit.SECONDS);
                if (line == null) {
                    continue;
                }
                handleNum++;
                String[] array = line.split("\1");
                if (array.length != 3) {
                    continue;
                }
                String imei = array[0];
                String androidId = array[1];
                String gaid = array[2];

                StringBuilder builder = new StringBuilder();
                if (!androidId.equals("0")) {
                    builder.append("android_id=").append(androidId).append("&");
                }
                if (!imei.equals("0")) {
                    builder.append("imei=").append(imei).append("&");
                }
                builder.append("package_name=").append(packageList);
                String body = builder.toString().toLowerCase();
                String xsign = md5(body + "&access_key=ushareit#prod#-20161001");
                Map<String, String> header = Maps.newHashMap();
                header.put("X-sign", xsign);
                header.put("Host", "54.223.197.126:9070");
                String json = HttpUtil.doPost("http://appcheck.ushareit.com/app", body, header);
                if (json.equals("no_sign")) {
                    System.out.println("no_sign");
                    continue;
                }
                Map<String, String> map = objectMapper.readValue(json, mapType);
                List<String> pkgs = Lists.newArrayList();
                for (Map.Entry<String, String> entry: map.entrySet()) {
                    if (entry.getValue().length() == 4) {
                        pkgs.add(entry.getKey());
                    }
                }
                if (pkgs.size() != 0) {
                    writeNum++;
                    output.put(MRUtils.JOINER.join(gaid, "gaid", "android", objectMapper.writeValueAsString(pkgs)));
                }
            } catch (InterruptedException e) {
                break;
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.printf("handle num: %d, write num: %d \n", handleNum, writeNum);
    }

    private String md5(String str) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        //md5.update(str.getBytes());
        char[] charArray = str.toCharArray();
        byte[] byteArray = new byte[charArray.length];

        for (int i = 0; i < charArray.length; i++)
            byteArray[i] = (byte) charArray[i];
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuilder hexValue = new StringBuilder();
        for (int i = 0; i < md5Bytes.length; i++){
            int val = ((int) md5Bytes[i]) & 0xff;
            if (val < 16)
                hexValue.append("0");
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public void stop() {
        stop = true;
    }
}
