package mobvista.dmp.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.Map;

/**
 * author: houying
 * date  : 16-11-3
 * desc  :
 */
public final class HttpUtil {
    private static final Log logger = LogFactory.getLog(HttpUtil.class);
    private static PoolingHttpClientConnectionManager cm;

    static {
        cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(40);
    }

    public static class HttpResult {
        private String content;
        private int statusCode;

        public HttpResult(String content, int statusCode) {
            this.content = content;
            this.statusCode = statusCode;
        }

        public String getContent() {
            return content;
        }

        public int getStatusCode() {
            return statusCode;
        }
    }

    public static HttpResult doGet(String url, HttpHost proxy) throws IOException {
        CloseableHttpResponse response = null;
        try {
            HttpClientBuilder builder = HttpClients.custom()
                    .setConnectionManager(cm);
            if (proxy != null) {
                builder.setRoutePlanner(new DefaultProxyRoutePlanner(proxy));
            }
            CloseableHttpClient client = builder.build();
            HttpGet get = new HttpGet(url);
            get.addHeader("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.71 Safari/537.36");
            get.addHeader("Connection", "Keep-Alive");
            response = client.execute(get);
            if (response.getStatusLine().getStatusCode() == 200) {
                return new HttpResult(EntityUtils.toString(response.getEntity()), 200);
            } else {
                //logger.info("[{} StatusCode: {}, proxy: {}]", url, response.getStatusLine().getStatusCode(), proxy != null ? proxy.getHostName():"null");
                return new HttpResult(null, response.getStatusLine().getStatusCode());
            }
        } finally {
            if (response != null) {
                EntityUtils.consume(response.getEntity());
                response.close();
            }
        }
    }

    public static String doPost(String url, String body, Map<String, String> headers) throws IOException {
        CloseableHttpResponse response = null;
        try {
            HttpClientBuilder builder = HttpClients.custom().setConnectionManager(cm);
            CloseableHttpClient client = builder.build();
            HttpPost req = new HttpPost(url);
            req.setEntity(new StringEntity(body));
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                req.setHeader(entry.getKey(), entry.getValue());
            }
            response = client.execute(req);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString(response.getEntity());
            } else {
                return null;
            }
        } finally {
            if (response != null) {
                EntityUtils.consume(response.getEntity());
                response.close();
            }
        }
    }
}
