package mobvista.dmp.util;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

/**
 * @package: mobvista.dmp.util
 * @author: wangjf
 * @date: 2019-11-22
 * @time: 11:48
 * @email: jinfeng.wang@mobvista.com
 * @phone: 152-1062-7698
 */
public class MD5Util {

    //  如果前几位为0，则会删除0，出现少一两位。不足
    public static String getMD5(String str) throws Exception {
        try {
            //  生成一个MD5加密计算摘要
            MessageDigest md = MessageDigest.getInstance("MD5");
            //  计算md5函数
            md.update(str.getBytes());
            //  digest()最后确定返回md5 hash值，返回值为8为字符串。因为md5 hash值是16位的hex值，实际上就是8位的字符
            //  BigInteger函数则将8位的字符串转换成16位hex值，用字符串来表示；得到字符串形式的hash值
            return new BigInteger(1, md.digest()).toString(16);
        } catch (Exception e) {
            throw new Exception("MD5加密出现错误，" + e.toString());
        }
    }

    public static String getMD5Str(String plainText) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte b[] = md.digest();
            int i;
            StringBuffer buf = new StringBuffer();
            for (int offset = 0; offset < b.length; offset++) {
                i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            //  32位加密
            return buf.toString();
            //  16位的加密
            //  return buf.toString().substring(8, 24);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void main(String[] args) throws Exception {
        UUID uid = UUID.randomUUID();
        String str = getMD5Str(uid.toString());
        System.out.println(uid.toString());
        System.out.println(str);
        //  MySQLUtil.update("dwh", "ods_user_info", "20191130");

    }
}