package mobvista.dmp.util.cassandra;

import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Row;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

/**
 * @package: mobvista.dmp.util.cassandra
 * @author: wangjf
 * @date: 2020/7/14
 * @time: 10:50 上午
 * @email: jinfeng.wang@mobvista.com
 * @phone: 152-1062-7698
 */
public class CassandraUtils {


    public static CompletableFuture<Row> query(CqlSession sessionStage, String query_sql) {

        CompletionStage<AsyncResultSet> responseStage = sessionStage.executeAsync(query_sql);

        CompletableFuture<Row> resultStage =
                responseStage.thenApply(AsyncPagingIterable::one).toCompletableFuture();

        return resultStage;
    }
}
