package mobvista.prd.datasource.table;

import com.google.common.collect.Lists;
import org.apache.poi.hssf.usermodel.*;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

/**
 * Created by Administrator on 2017/3/13 0013.
 * desc：dsp与M系统全部的性别年龄
 */
public class CreateAllGenderAgeTable {
    public static void main(String[] args) throws IOException {
        List<String> dspList = readAll("./dspCount.txt", "DSP");
        List<String> mList = readAll("./mCount.txt", "M系统");

        FileOutputStream fos = new FileOutputStream("./性别年龄.xls");
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet s = wb.createSheet();
        List<String> head = Lists.newArrayList();//表头
        head.add("Data source");
        head.add("DMP DAU");
        head.add("Male");
        head.add("Female");
        head.add("Gender unknown");
        head.add("Age 0-18");
        head.add("Age 19-25");
        head.add("Age 26-45");
        head.add("Age 46-60");
        head.add("Age above 60");
        head.add("Age unknown");
        int columnHead = 0;
        HSSFRow rowOne = s.createRow(0);
        for (String column : head) {
            HSSFCell cell = rowOne.createCell(columnHead, 0);
            HSSFRichTextString hts = new HSSFRichTextString(column);
            cell.setCellValue(hts);
            columnHead++;
        }
        columnHead = 0;
        rowOne = s.createRow(1);
        for (String column : dspList) {
            HSSFCell cell = rowOne.createCell(columnHead, 0);
            HSSFRichTextString hts = new HSSFRichTextString(column);
            cell.setCellValue(hts);
            columnHead++;
        }
        columnHead = 0;
        rowOne = s.createRow(2);
        for (String column : mList) {
            HSSFCell cell = rowOne.createCell(columnHead, 0);
            HSSFRichTextString hts = new HSSFRichTextString(column);
            cell.setCellValue(hts);
            columnHead++;
        }
        wb.write(fos);
        fos.flush();
        fos.close();
    }

    public static List readAll(String file, String line) throws IOException {
        List<String> list = Lists.newArrayList();
        list.add(line);
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        String s = br.readLine();
        while (s != null) {

            String[] fields = s.split("\t", -1);
            for (String field : fields) {
                list.add(field);
            }
            s = br.readLine();
        }
        br.close();
        fr.close();
        return list;
    }
}
