# coding=utf-8
import datetime

festival = {
    "01": {
        "01": "元旦"
    },
    "02": {
        "14": "情人节"
    },
    "03": {
        "08": "妇女节",
        "12": "植树节",
        "15": "消费者权益日"
    },
    "04": {
        "01": "愚人节",
        "22": "世界地球日"
    },
    "05": {
        "01": "劳动节",
        "04": "青年节",
        "18": "国际博物馆日",
        "12": "护士节"
    },
    "06": {
        "01": "儿童节",
        "24": "国际奥林匹克日",
        "05": "世界环境日",
        "23": "世界骨质疏松日"
    },
    "07": {
        "01": "建党节"
    },
    "08": {
        "01": "建军节"
    },
    "09": {
        "10": "教师节",
        "03": "抗战胜利纪念日",
        "18": "孔子诞辰"
    },
    "10": {
        "01": "国庆节",
        "24": "联合国日",
        "06": "老人节"
    },
    "11": {
        "17": "世界学生日"
    },
    "12": {
        "24": "平安夜",
        "25": "圣诞节"
    }
}

if __name__ == '__main__':
    start_time = datetime.datetime(2012, 01, 01, 00, 00)
    end_time = datetime.datetime(2050, 01, 01, 00, 00)
    while start_time < end_time:
        array = start_time.strftime("%Y %m %d %2H %w").split(" ")
        long_dt = start_time.strftime("%Y-%m-%d")
        short_dt = start_time.strftime("%Y%m%d")
        # 季度
        array.append("Q" + str(1 + int(array[1]) / 4))
        # 节假日
        if array[1] in festival and array[2] in festival[array[1]]:
            array.append(festival[array[1]][array[2]])
        else:
            array.append("")

        for i in range(1, 13):
            if i < 10:
                array[3] = "0" + str(i)
            else:
                array[3] = str(i)
            print long_dt + '\t' + short_dt + array[3] + '\t' + '\t'.join(array)
        start_time = start_time + datetime.timedelta(days=1)

