package mobvista.dmp.datasource.bytedance

import java.net.URI
import java.util

import mobvista.dmp.common.CommonSparkJob
import mobvista.prd.datasource.util.GsonUtil
import org.apache.commons.cli.Options
import org.apache.hadoop.fs.{FileSystem, Path}
import org.apache.spark.sql.{SaveMode, SparkSession}

import scala.collection.JavaConversions._

/**
  * @package: mobvista.dmp.datasource.bytedance
  * @author: wangjf
  * @date: 2019/3/4
  * @time: 下午1:44
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class ByteDanceDaily extends CommonSparkJob {

  override protected def buildOptions(): Options = {
    val options = new Options
    options.addOption("input", true, "[must] input")
    options.addOption("output", true, "[must] output")
    options.addOption("coalesce", true, "[must] coalesce")
    options
  }

  override protected def run(args: Array[String]): Int = {
    val commandLine = commParser.parse(options, args)
    if (!checkMustOption(commandLine)) {
      printUsage(options)
      return -1
    } else {
      printOptions(commandLine)
    }

    val input = commandLine.getOptionValue("input")
    val output = commandLine.getOptionValue("output")
    val coalesce = commandLine.getOptionValue("coalesce")

    val spark = SparkSession.builder()
      .appName("ByteDanceDaily")
      .config("spark.rdd.compress", "true")
      .config("spark.io.compression.codec", "snappy")
      .config("spark.sql.orc.filterPushdown", "true")
      .config("spark.sql.warehouse.dir", "s3://mob-emr-test/spark-warehouse")
      .config("spark.serializer", "org.apache.spark.serializer.KryoSerializer")
      .enableHiveSupport()
      .getOrCreate()
    val sc = spark.sparkContext

    FileSystem.get(new URI(s"s3://mob-emr-test"), spark.sparkContext.hadoopConfiguration).delete(new Path(output), true)
    try {
      val rdd = sc.textFile(input).map(r => {
        val map = Map("1128" -> "1142110895")
        val json = GsonUtil.String2JsonObject(r)
        val apps = json.get("val").getAsJsonObject.get("toutiaoDmpInstallApps").toString
        val device_id = json.get("key").getAsJsonObject.get("idfaGaid").getAsString.toUpperCase
        val device_type = "idfa"
        val platform = "ios"
        val country = "CN"
        val set = new util.HashSet[String]()
        if (apps.startsWith("[") && apps.endsWith("]")) {
          val app = apps.substring(1, apps.length - 1).split(",")
          app.foreach(r => {
            if (map.keySet.contains(r)) {
              set.add(map(r))
            }
          })
        }
        var package_array = ""
        set.iterator().foreach(s => {
          package_array += s + "#"
        })
        ByteDance(device_id, device_type, platform, package_array.substring(0, package_array.length - 1), country)
      })
      import spark.implicits._
      rdd.toDF.coalesce(coalesce.toInt).write
        .mode(SaveMode.Overwrite)
        .option("orc.compress", "zlib")
        .orc(output)
    } finally {
      sc.stop()
      spark.stop()
    }
    0
  }
}

object ByteDanceDaily {
  def main(args: Array[String]): Unit = {
    new ByteDanceDaily().run(args)
  }
}