package mobvista.dmp.datasource.ga

import mobvista.dmp.datasource.newtag.MatchInterestTagDaily
import org.apache.spark.sql.{DataFrame, SparkSession}

/**
  * 处理 ga 天数据
  */
class GaTagDaily extends MatchInterestTagDaily {

  /**
    * 解析天处理结果数据
    *
    * @param array
    * @param date
    * @return
    */

  def processDailyData(date: String, spark: SparkSession): DataFrame = {
    val sql = mobvista.dmp.datasource.newtag.Constant.ga_sql.replace("@dt", date)
    spark.sql(sql)
  }
}

object GaTagDaily {
  def main(args: Array[String]): Unit = {
    new GaTagDaily().run(args)
  }
}