package mobvista.dmp.datasource.iqiyi

import java.net.URI

import mobvista.dmp.common.CommonSparkJob
import org.apache.commons.cli.Options
import org.apache.hadoop.fs.{FileSystem, Path}
import org.apache.spark.sql.SparkSession


class EtlOtherIqiyiActivationData extends CommonSparkJob with Serializable  {
  override protected def buildOptions(): Options = {
    val options = new Options
    options.addOption("dt_today", true, "[must] dt_today")
    options.addOption("dt_oneday_ago", true, "[must] dt_oneday_ago")
    options.addOption("output",true, "[must] output")
    options
  }

  override protected def run(args: Array[String]): Int = {
    val commandLine = commParser.parse(options, args)
    if (!checkMustOption(commandLine)) {
      printUsage(options)
      return -1
    } else printOptions(commandLine)

    val dt_today = commandLine.getOptionValue("dt_today")
    val dt_oneday_ago = commandLine.getOptionValue("dt_oneday_ago")
    val output = commandLine.getOptionValue("output")

    val spark = SparkSession.builder()
      .appName("EtlOtherIqiyiActivationData")
      .config("spark.rdd.compress", "true")
      .config("spark.io.compression.codec", "snappy")
      .config("spark.sql.orc.filterPushdown", "true")
      .config("spark.sql.warehouse.dir", "s3://mob-emr-test/spark-warehouse")
      .config("spark.serializer", "org.apache.spark.serializer.KryoSerializer")
      .enableHiveSupport()
      .getOrCreate()



    FileSystem.get(new URI(s"s3://mob-emr-test"), spark.sparkContext.hadoopConfiguration).delete(new Path(output), true)

    val sc = spark.sparkContext
    try {

      val sql1 =
        s"""
           |select distinct t1.device_id from
           |(select device_id from dwh.dm_install_list_v2
           |where dt='${dt_today}' and business='iqiyi_activation' and device_type='imeimd5'
           |and package_name in ('com.iqiyi.foractivation')) t1
           |inner join
           |(select device_id from dwh.dm_install_list_v2
           |where dt='${dt_oneday_ago}' and business='dsp_req' and device_type='imeimd5'
           |and package_name in ('com.qiyi.video_oppo')) t2
           |on t1.device_id=t2.device_id
        """.stripMargin

      spark.sql(sql1).rdd.map(_.mkString).coalesce(50)
        .saveAsTextFile(output)

    } finally {
      spark.stop()
    }
    0
  }
}


object EtlOtherIqiyiActivationData {
  def main(args: Array[String]): Unit = {
    new EtlOtherIqiyiActivationData().run(args)
  }
}
