package mobvista.dmp.datasource.joypac

import java.text.SimpleDateFormat

import mobvista.dmp.datasource.newtag.{Constant, MatchInterestTagDaily, TagDaily}
import org.apache.spark.sql.{DataFrame, SparkSession}

import scala.collection.mutable.ArrayBuffer

/**
  * @package: mobvista.dmp.datasource.adn
  * @author: wangjf
  * @date: 2019/3/19
  * @time: 下午1:51
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
class JoypacTagDaily extends MatchInterestTagDaily with Serializable {
  val sdf1 = new SimpleDateFormat("yyyy-MM-dd")
  val sdf2 = new SimpleDateFormat("yyyyMMdd")

  override def processDailyData(date: String, spark: SparkSession): DataFrame = {
    val date2 = sdf1.format(sdf2.parse(date))
    val sql = Constant.joypacios_sql.replace("@dt", date2)

    val rdd = spark.sql(sql).rdd.mapPartitions(rs => {
      rs.map(r => {
        TagDaily(r.getAs("device_id"), r.getAs("device_type"), r.getAs("platform"), r.getAs("package_name"))
      })
    }).flatMap(r => {
      val buffer = new ArrayBuffer[TagDaily]()
      val device_id = r.device_id
      val device_type = r.device_type
      val platform = r.platform
      val install_list = r.package_name
      install_list.split(";").foreach(package_name => {
        buffer += TagDaily(device_id, device_type, platform, package_name)
      })
      buffer
    })
    import spark.implicits._
    rdd.toDF
  }
}

object JoypacTagDaily {
  def main(args: Array[String]): Unit = {
    new JoypacTagDaily().run(args)
  }
}