package mobvista.dmp.datasource.mpsdk

import java.util

import com.google.gson.{JsonArray, JsonObject}
import mobvista.dmp.common.CommonInstallList
import mobvista.prd.datasource.util.GsonUtil
import org.apache.commons.lang.StringUtils

import scala.collection.JavaConversions._
import scala.collection.mutable.ArrayBuffer

/**
  * 将mpsdk天数据合并到安装列表全量数据中
  */
class MPSDKInstallList extends CommonInstallList {

  /**
    * 解析天处理结果数据
    * @param array
    * @param date
    * @return
    */
  def processDailyData(array : Array[String], date : String): Array[Tuple2[String, InstallInfo]] = {
    val buffer = new ArrayBuffer[Tuple2[String, InstallInfo]]()
    try {
      val device_id = array(0)
      val androidId = array(1)
      val package_list = array(5)
      if (StringUtils.isNotEmpty(package_list) && package_list.startsWith("[")) {
        val jsonArray = GsonUtil.String2JsonArray(package_list)
        val set = GsonUtil.fromJson(jsonArray, classOf[util.HashSet[String]])
        set.foreach(pkg => {
          val installInfo = new InstallInfo(pkg, date)
          if (StringUtils.isNotEmpty(installInfo.getPackage_name())) {
            buffer += Tuple2(s"$device_id${FIELD_SPLIT}gaid${FIELD_SPLIT}android", installInfo)
            buffer += Tuple2(s"$androidId${FIELD_SPLIT}androidid${FIELD_SPLIT}android", installInfo)  // 新增 AndroidID需求
          }
        })
      }
    } catch {
      case e: Exception => {
        e.printStackTrace()
      }
    }

    buffer.toArray
  }
}

object MPSDKInstallList {
  def main(args: Array[String]): Unit = {
    new MPSDKInstallList().run(args)
  }
}
