package mobvista.dmp.datasource.newtag

import mobvista.dmp.datasource.dm.Constant.{allZero, didPtn}

/**
  * @package: mobvista.dmp.datasource.newtag
  * @author: wangjf
  * @date: 2019/3/18
  * @time: 下午2:12
  * @email: jinfeng.wang@mobvista.com
  * @phone: 152-1062-7698
  */
object Constant {

  val tracking_3s_sql: String =
    """
      |SELECT device_id, device_type, platform, package_name
      | FROM dwh.etl_3s_install_daily WHERE `date` = '@dt'
    """.stripMargin

  val dsp_req_sql: String =
    """
      |SELECT device_id, device_type, platform, package_list
      | FROM dwh.etl_dsp_request_daily WHERE `date` = '@dt'
    """.stripMargin

  val adn_reuqest_sdk_sql: String =
    """
      |SELECT device_id, device_type, platform, package_name
      | FROM dwh.etl_adn_sdk_request_daily WHERE `date` = '@dt'
    """.stripMargin

  val adn_install_sql: String =
    """
      |SELECT device_id, device_type, platform, package_name
      | FROM dwh.etl_adn_install_daily WHERE `date` = '@dt'
    """.stripMargin

  val adn_request_other_sql: String =
    """
      |SELECT device_id, device_type, platform, package_name
      | FROM dwh.etl_adn_request_other_daily WHERE `date` = '@dt'
    """.stripMargin

  val adn_sdk_sql: String =
    """
      |SELECT device_id, device_type, platform, install_list
      | FROM dwh.etl_adn_sdk_daily WHERE `day` = '@dt'
    """.stripMargin

  val mp_sql: String =
    """
      |SELECT device_id, 'gaid' device_type, 'android' platform, package_list
      | FROM dwh.etl_mpsdk_request_daily WHERE `dt` = '@dt'
    """.stripMargin

  val ga_sql: String =
    """
      |SELECT device_id, device_type, platform, package_name
      | FROM dwh.ods_ga_install_daily WHERE `date` = '@dt'
    """.stripMargin

  val clever_sql: String =
    """
      |SELECT device_id, device_type, platform, package_name
      | FROM dwh.etl_adn_clever_daily WHERE `date` = '@dt'
    """.stripMargin

  val bytedance_sql: String =
    """
      |SELECT device_id, device_type, platform, package_name
      | FROM dwh.etl_bytedance_daily WHERE `dt` = '@dt'
    """.stripMargin

  val joypacios_sql: String =
    """
      |SELECT device_id, device_type, platform, package_name
      | FROM dwh.joypac_sdk_daily WHERE `dt` = '@dt'
    """.stripMargin

  val facebook_sql: String =
    """
      |SELECT device_id, device_type, platform, package_name
      | FROM dwh.etl_facebook_daily WHERE `dt` = '@dt'
    """.stripMargin


  val postback_sql: String =
    """
      |SELECT device_id, device_type, platform, package_name
      | FROM dwh.etl_3s_postback_daily WHERE `dt` = '@dt'
    """.stripMargin



  val ali_sql: String =
    """
      |SELECT device_id, device_type, platform, package_name
      | FROM dwh.etl_baichuan_daily WHERE `dt` = '@dt'
    """.stripMargin

  def check_deviceId(device_id: String): Boolean = {
    device_id.matches(didPtn) && !device_id.equals(allZero)
  }
}