package mobvista.dmp.demo

import java.util.concurrent.CountDownLatch

import mobvista.dmp.runner.MatchTask
import mobvista.dmp.thread.TaskPool
import org.apache.commons.cli.{BasicParser, CommandLine, HelpFormatter, Options}
import org.apache.commons.lang.StringUtils
import org.apache.log4j.Logger


/**
  * Created by fl on 2017/7/13.
  */
class MatchTrackId {
  val log = Logger.getLogger(classOf[MatchTrackId])

  def run(args: Array[String]): Int = {
    try {
      val options = buildOption()
      val parser = new BasicParser
      val commandLine = parser.parse(options, args)
      if (!checkMustOption(commandLine)) {
        printUsage(options)
        return 1
      }

      val input = commandLine.getOptionValue("input")
      val output = commandLine.getOptionValue("output")

      log.info("**************************")
      log.info(s"* input = $input")
      log.info(s"* output = $output*")
      log.info("**************************")

      val inputSplits = StringUtils.splitPreserveAllTokens(input, ";", -1)
      val doneSignal = new CountDownLatch(inputSplits.length)
      for (i <- 0 until inputSplits.length) {

        TaskPool.getThreadPool.execute(new MatchTask(inputSplits(i), s"$output-$i", doneSignal))
      }

      doneSignal.await();

    } catch {
      case e: Exception => {
        Thread.currentThread().interrupt()
        log.error("Match trachId fail", e)
        return 1
      }
    } finally {
      TaskPool.shutdownAndAwaitTermination(TaskPool.getThreadPool)
    }
    0
  }

  def buildOption(): Options = {
    val options = new Options
    options.addOption("input", true, "[must] input data file path ")
    options.addOption("output", true, "[must] output result file path ")
    options
  }

  def checkMustOption(commands: CommandLine): Boolean = {
    if (!commands.hasOption("input")) {
      log.info("please set input ")
      return false
    }
    if (!commands.hasOption("output")) {
      log.info("please set output ")
      return false
    }
    true
  }

  def printUsage(options: Options): Unit = {
    val help = new HelpFormatter
    help.printHelp(this.getClass.getSimpleName, options)
  }
}

object MatchTrackId {
  def main(args: Array[String]): Unit = {
    new MatchTrackId().run(args)
  }
}