package mobvista.dmp.function

import java.util

import com.googlecode.aviator.runtime.`type`.{AviatorJavaType, AviatorObject}
import com.googlecode.aviator.runtime.function.FunctionUtils
import org.apache.spark.sql.Row

import scala.collection.mutable.ArrayBuffer

class SplitORCInputData extends CommonFunction {
  override def getName = "split_orc_input_data"

  override def call(env: util.Map[String, AnyRef], arg1: AviatorObject, arg2 : AviatorObject) = {
    val row = FunctionUtils.getJavaObject(arg1, env).asInstanceOf[Row]
    val indices = FunctionUtils.getStringValue(arg2, env)
    val buffer = new ArrayBuffer[String]
    splitFun(indices, ",")
      .foreach(index => {
        buffer += row.getString(index.toInt)
      })
    env.put("array", buffer.toArray)
    new AviatorJavaType("array")
  }

  override def call(env: util.Map[String, AnyRef], arg1: AviatorObject) = {
    val row = FunctionUtils.getJavaObject(arg1, env).asInstanceOf[Row]
    val buffer = new ArrayBuffer[String]
    for (i <- 0 until row.size) {
      buffer += row.getString(i)
    }
    env.put("array", buffer.toArray)
    new AviatorJavaType("array")
  }
}
