package mobvista.dmp.function

import java.util

import com.googlecode.aviator.runtime.`type`.{AviatorJavaType, AviatorObject}
import com.googlecode.aviator.runtime.function.FunctionUtils
import mobvista.dmp.util.BytesRefUtil
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable

import scala.collection.mutable.ArrayBuffer

class SplitRCFileInputData extends CommonFunction {
  override def getName = "split_rcfile_input_data"

  override def call(env: util.Map[String, AnyRef], arg1: AviatorObject, arg2 : AviatorObject) = {
    val line = FunctionUtils.getJavaObject(arg1, env).asInstanceOf[BytesRefArrayWritable]
    val indices = FunctionUtils.getStringValue(arg2, env)
    val buffer = new ArrayBuffer[String]
    splitFun(indices, ",")
      .foreach(index => {
        buffer += BytesRefUtil.BytesRefWritableToString(line.get(index.toInt))
      })
    env.put("array", buffer.toArray)
    new AviatorJavaType("array")
  }
}
