package mobvista.dmp.vo

import com.google.gson.JsonArray

case class Record(var eventTime: String,
             var source: Source,
             var identifiers: Indentifiers,
             var data: JsonArray
            ) extends Serializable

case class Source(name: String, stype: String) extends Serializable
case class Indentifiers(primary: Identify, alternateIdList: List[Identify]) extends Serializable
case class Identify(id: String, ptype: String, pii: String, timestamp: String, detail: Detail) extends Serializable
case class Detail(deviceModel: String, operatingSystem: String, manufacturer: String, macAddress: String) extends Serializable
//case class ReqData(eventType: String, dataList: List[EventData])
case class AppEvent(appStatus: Int, appList: List[String], eventTime: String) extends Serializable
case class LocationEvent(latitude: Double, longitude: Double, ipAddress: String, startTime: Long, endTime: Long
                        , duration: Long, evnetDate: String, city: String, state: String, country: String, zipcode: String) extends Serializable
case class WebEvent(ua: String, urlList: List[UrlInfo]) extends Serializable
case class UrlInfo(url: String, urlContext: String, eventDate: String) extends Serializable
case class FactEvent(urlInfo: List[String], primaryWork: List[String], language: List[String],
                     inferences: List[Int], partner_inferences: List[Int], other: String) extends Serializable
case class Residence(latitude: Double, longitude: Double, locationDetail: String, city: String, state: String
                    , country: String, zipcode: String, ips: List[IPSeries]) extends Serializable
case class IPSeries(ip: String, ts: String) extends Serializable