package mobvista.prd.main

import java.net.URI
import java.util

import mobvista.prd.datasource.util.GsonUtil
import org.apache.commons.lang.StringUtils
import org.apache.hadoop.fs.{FileSystem, Path}
import org.apache.spark.{SparkConf, SparkContext}

import scala.collection.JavaConversions._

/**
  * 重游戏DAU统计
  */
class WeightGame extends Serializable {
  val map : util.Map[String, String] = new util.HashMap[String, String]()
  map.put("1015521325", "1")
  map.put("1034649723", "1")
  map.put("1040083067", "1")
  map.put("1053012308", "1")
  map.put("1071976327", "1")
  map.put("1082959065", "1")
  map.put("1084930849", "1")
  map.put("1090814275", "1")
  map.put("1094591345", "1")
  map.put("1128255542", "1")
  map.put("1132537738", "1")
  map.put("1149211719", "1")
  map.put("1160056295", "1")
  map.put("1164388317", "1")
  map.put("1175987006", "1")
  map.put("1181774280", "1")
  map.put("1186994231", "1")
  map.put("1204094414", "1")
  map.put("1211063618", "1")
  map.put("1234148531", "1")
  map.put("1252935241", "1")
  map.put("431946152", "1")
  map.put("479516143", "1")
  map.put("529479190", "1")
  map.put("580399292", "1")
  map.put("667728512", "1")
  map.put("741949324", "1")
  map.put("852882903", "1")
  map.put("852912420", "1")
  map.put("866037912", "1")
  map.put("882680657", "1")
  map.put("895687962", "1")
  map.put("921022358", "1")
  map.put("934596429", "1")
  map.put("945274928", "1")
  map.put("958763157", "1")
  map.put("987942897", "1")
  map.put("997667431", "1")
  map.put("com.and.riseofthekings", "1")
  map.put("com.aniplex.fategrandorder", "1")
  map.put("com.bandainamcoent.onepiecetresurecruisekr", "1")
  map.put("com.cjenm.sknights", "1")
  map.put("com.coc.kr.kyzhmx.googleone", "1")
  map.put("com.com2us.smon.normal.freefull.google.kr.android.common", "1")
  map.put("com.ea.game.starwarscapital_row", "1")
  map.put("com.ENP.therings.kr.googleplay", "1")
  map.put("com.entermate.luthiel", "1")
  map.put("com.epicactiononline.ffxv.ane", "1")
  map.put("com.epicwaronline.ms", "1")
  map.put("com.ftt.fivekings_aos", "1")
  map.put("com.ftt.samblade.kr.aos", "1")
  map.put("com.funplus.kingofavalon", "1")
  map.put("com.gamevil.psrforkakao", "1")
  map.put("com.gtarcade.lod", "1")
  map.put("com.hcg.cok.gp", "1")
  map.put("com.hcg.ctw.gp", "1")
  map.put("com.igg.android.lordsmobile", "1")
  map.put("com.igg.castleclash", "1")
  map.put("com.igg.castleclash_id", "1")
  map.put("com.kakaogames.lmzgplay", "1")
  map.put("com.kakaogames.onmyouji", "1")
  map.put("com.longtech.lastwars.gp", "1")
  map.put("com.machinezone.gow", "1")
  map.put("com.moonton.magicrush", "1")
  map.put("com.ncsoft.finalbladekr", "1")
  map.put("com.ncsoft.lineagem", "1")
  map.put("com.ncsoft.lineagem19", "1")
  map.put("com.netmarble.lineageII", "1")
  map.put("com.netmarble.mherosgb", "1")
  map.put("com.netmarble.rav", "1")
  map.put("com.netmarble.sknightsgb", "1")
  map.put("com.nexon.caocao", "1")
  map.put("com.nexonm.dominations.adk", "1")
  map.put("com.NextFloor.DestinyChild", "1")
  map.put("com.nianticlabs.pokemongo", "1")
  map.put("com.ninjakiwi.bftg", "1")
  map.put("com.nintendo.zaba", "1")
  map.put("com.pang.obba2.google", "1")
  map.put("com.plarium.vikings", "1")
  map.put("com.roblox.client", "1")
  map.put("com.square_enix.android_googleplay.FFBEWW", "1")
  map.put("com.stac.aok", "1")
  map.put("com.stac.empire.main", "1")
  map.put("com.supercell.clashofclans", "1")
  map.put("com.supercell.clashroyale", "1")
  map.put("com.ujoy.rings", "1")
  map.put("com.vespainteractive.KingsRaid", "1")
  map.put("com.webzen.muorigin.google", "1")
  map.put("com.yogrtgame.kol", "1")
  map.put("jp.co.applibot.kamuraitribe", "1")
  map.put("jp.colopl.wcat", "1")
  map.put("jp.mbga.a12016007.lite", "1")
  map.put("kr.txwy.and.snqx", "1")
  map.put("zombie.survival.craft.z", "1")

  val dataSplit = "\t"

  def run (args : Array[String]): Int = {
    val dailyPath = args(0)
    val installPath = args(1)
    val output = args(2)

    println("*********************************")
    println(s"* input = $dailyPath")
    println(s"* installPath = $installPath")
    println(s"* output = $output")
    println("*********************************")

    val conf = new SparkConf().setAppName("WeightGame")
    val sc = new SparkContext(conf)

    val dailyData = sc.textFile(dailyPath)
    val dailyRDD  = dailyData.map(record => {
      val splits = StringUtils.splitPreserveAllTokens(record, dataSplit, -1)
      val device_id = splits(0)
      val device_type = splits(1)
      (s"$device_id$dataSplit$device_type", null)
    })
    .distinct(200)

    val installData = sc.textFile(installPath)
    val installRDD = installData.map(doMap(_, map))
      .filter(_ != null)
      .distinct(200)

    FileSystem.get(new URI(s"s3://mob-emr-test"), sc.hadoopConfiguration).delete(new Path(output),true)

    dailyRDD
      .join(installRDD, 200)
      .map(_._1)
      .saveAsTextFile(output)
    sc.stop()
    0
  }

  def doMap(record : String, map : util.Map[String, String]) : Tuple2[String, String] = {
    val splits = StringUtils.splitPreserveAllTokens(record, dataSplit, -1)
    val device_id = splits(0)
    val device_type = splits(1)
    val installList = splits(3)
    val jsonArray = GsonUtil.String2JsonArray(installList)
    jsonArray.foreach(element => {
      val packageName = element.getAsJsonObject.get("package_name").getAsString
      val temp = map.get(packageName)
      if (temp != null) {
        return (s"$device_id$dataSplit$device_type", null)
      }
    })
    null
  }
}



object WeightGame {
  def main(args: Array[String]): Unit = {
    new WeightGame().run(args)
  }
}
