package test

import java.util.Map.Entry

import com.google.gson.JsonElement
import mobvista.prd.datasource.util.GsonUtil

/**
  * @package: test
  * @author: wangjf
  * @create: 2018-08-15 15:31
  **/
object AgeLabel {
  def main(args: Array[String]): Unit = {
    val ageRange =
      """
        |{"age_and_source":{"25-44":"dsp"},"age_and_proportion":{"60+":3.4E-5,"25-44":0.607727,"18-24":0.337427,"0-17":0.047794,"45-59":0.007018}}
      """.stripMargin
    println(getAge(ageRange))
  }

  def getAge(ageRange: String): Int = {
    var age: String = null
    if (ageRange != null) {
      var max: Double = 0.0
      var entry: Entry[String, JsonElement] = null
      val json = GsonUtil.String2JsonObject(ageRange)
      val ageJson = json.get("age_and_proportion").getAsJsonObject()
      val itr = ageJson.entrySet().iterator()
      while (itr.hasNext()) {
        entry = itr.next()
        val temp = entry.getValue().getAsDouble()
        if (temp > max) {
          max = temp
          age = entry.getKey()
        }
      }
      //  return Util.calcLabel(age.toInt)
    }
    return getAgeLabel(age)
  }

  def getAgeLabel(generation: String): Int = {
    var label = 0
    generation match {
      case "0-17" =>
        label = 1
      case "18-24" =>
        label = 2
      case "25-44" =>
        label = 3
      case "45-59" =>
        label = 4
      case "60+" =>
        label = 5
      case _ =>
    }
    return label
  }
}
