/*
 * Decompiled with CFR 0.152.
 */
package io.clickhouse.spark.connector;

import io.clickhouse.spark.connection.ClickHouseDataSource;
import io.clickhouse.spark.connection.ClickHouseDataSource$;
import io.clickhouse.spark.connection.ConnectionPooledDBUrl;
import io.clickhouse.spark.connection.JdbcConnection;
import io.clickhouse.spark.connector.ClickhouseConnector$;
import io.clickhouse.spark.connector.ConnectorConf;
import io.clickhouse.spark.connector.ShardUnavailableException;
import io.clickhouse.spark.connector.ShardUnavailableException$;
import io.clickhouse.spark.connector.TableScanner;
import io.clickhouse.spark.connector.partitioner.ClickhousePartition;
import io.clickhouse.spark.connector.partitioner.PartitionQuery$;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.NoSuchElementException;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001-\u00111c\u00117jG.Dw.^:f\u0007>tg.Z2u_JT!a\u0001\u0003\u0002\u0013\r|gN\\3di>\u0014(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0006dY&\u001c7\u000e[8vg\u0016T\u0011!C\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001\u0019I)\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003-yi\u0011a\u0006\u0006\u00031e\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000biQ!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sO&\u0011qd\u0006\u0002\b\u0019><w-\u001b8h\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013\u0001B2p]\u001a\u0004\"a\t\u0013\u000e\u0003\tI!!\n\u0002\u0003\u001b\r{gN\\3di>\u00148i\u001c8g\u0011!9\u0003A!A!\u0002\u0013A\u0013AD5oSR$\u0015\r^1T_V\u00148-\u001a\t\u0003S1j\u0011A\u000b\u0006\u0003W\u0011\t!bY8o]\u0016\u001cG/[8o\u0013\ti#F\u0001\u000bDY&\u001c7\u000eS8vg\u0016$\u0015\r^1T_V\u00148-\u001a\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u000591\r\\;ti\u0016\u0014\bCA\u00195\u001d\ti!'\u0003\u00024\u001d\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019d\u0002C\u00039\u0001\u0011\u0005\u0011(\u0001\u0004=S:LGO\u0010\u000b\u0005umbT\b\u0005\u0002$\u0001!)\u0011e\u000ea\u0001E!)qe\u000ea\u0001Q!)qf\u000ea\u0001a!Qq\b\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002!\u0002\u0007a$\u0013\u0007\u0005\u0003\u000e\u0003\u000eC\u0013B\u0001\"\u000f\u0005\u0019!V\u000f\u001d7feA!A)S&O\u001b\u0005)%B\u0001$H\u0003%IW.\\;uC\ndWM\u0003\u0002I\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005)+%aA'baB\u0011Q\u0002T\u0005\u0003\u001b:\u00111!\u00138u!\ryuK\u0017\b\u0003!Vs!!\u0015+\u000e\u0003IS!a\u0015\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011B\u0001,\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001W-\u0003\u0007M+\u0017O\u0003\u0002W\u001dA\u00111\fY\u0007\u00029*\u0011QLX\u0001\u0004]\u0016$(\"A0\u0002\t)\fg/Y\u0005\u0003Cr\u00131\"\u00138fi\u0006#GM]3tg\"91\r\u0001b\u0001\n\u0003!\u0017A\u00033bi\u0006\u001cv.\u001e:dKV\tQ\r\u0005\u00032M.s\u0015B\u0001&7\u0011\u0019A\u0007\u0001)A\u0005K\u0006YA-\u0019;b'>,(oY3!\u0011\u001dQ\u0007A1A\u0005\u0002-\fQ\u0002\u001e5f\t\u0006$\u0018mU8ve\u000e,W#\u0001\u0015\t\r5\u0004\u0001\u0015!\u0003)\u00039!\b.\u001a#bi\u0006\u001cv.\u001e:dK\u0002BQa\u001c\u0001\u0005\u0002A\fq!\u001a=fGV$X\rF\u0002rir\u0004\"a\t:\n\u0005M\u0014!\u0001\u0004+bE2,7kY1o]\u0016\u0014\b\"B;o\u0001\u00041\u0018!\u00039beRLG/[8o!\t9(0D\u0001y\u0015\tI(!A\u0006qCJ$\u0018\u000e^5p]\u0016\u0014\u0018BA>y\u0005M\u0019E.[2lQ>,8/\u001a)beRLG/[8o\u0011\u0015ih\u000e1\u00011\u0003\u0015\tX/\u001a:z\u0011\u0019y\b\u0001\"\u0003\u0002\u0002\u0005\u0001R\r_3dkR,7\u000b^1uK6,g\u000e\u001e\u000b\bc\u0006\r\u0011QBA\b\u0011\u001d\t)A a\u0001\u0003\u000f\t!b\u001d5be\u0012tu\u000eZ3t!\u0011y\u0015\u0011\u0002\u0019\n\u0007\u0005-\u0011L\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011\u0015ih\u00101\u00011\u0011\u001d\t\tB a\u0001\u0003'\t!a\u00199\u0011\u0007%\n)\"C\u0002\u0002\u0018)\u0012QcQ8o]\u0016\u001cG/[8o!>|G.\u001a3E\u0005V\u0013H\u000eC\u0004\u0002\u001c\u0001!I!!\b\u0002%\u001d,Go\u00117vgR,'/T3uC\u0012\fG/Y\u000b\u0003\u0003?\u0001b!!\t\u0002$\u0005\u001dbBA\u0007V\u0013\r\t)#\u0017\u0002\u0005\u0019&\u001cH\u000f\u0005\u0005\u000e\u0003SY\u0015QFA\u0017\u0013\r\tYC\u0004\u0002\u0007)V\u0004H.Z\u001a\u0011\t5\ty\u0003M\u0005\u0004\u0003cq!!B!se\u0006L\bbBA\u001b\u0001\u0011%\u0011qG\u0001\fI\u0016$Xm\u0019;TQ\u0006\u0014H\r\u0006\u0004\u0002:\u0005}\u0012Q\t\t\u0005\u001b\u0005m2*C\u0002\u0002>9\u0011aa\u00149uS>t\u0007\u0002CA!\u0003g\u0001\r!a\u0011\u0002\u001f\rdWo\u001d;fe6+G/\u00193bi\u0006\u0004RaTA\u0012\u0003OAq!a\u0012\u00024\u0001\u0007\u0001'\u0001\u0003i_N$\bbBA&\u0001\u0011%\u0011QJ\u0001\u000f[\u0006\\W\rR1uCN{WO]2f)\t\ty\u0005\u0005\u0003\u000e\u0003\u0016DsaBA*\u0005!\u0005\u0011QK\u0001\u0014\u00072L7m\u001b5pkN,7i\u001c8oK\u000e$xN\u001d\t\u0004G\u0005]cAB\u0001\u0003\u0011\u0003\tIf\u0005\u0003\u0002X1\u0011\u0002b\u0002\u001d\u0002X\u0011\u0005\u0011Q\f\u000b\u0003\u0003+B!\"!\u0019\u0002X\t\u0007I\u0011BA2\u0003M\u0019wN\u001c8fGRLwN\u001c)p_2\u001c\u0015m\u00195f+\t\t)\u0007\u0005\u0005\u0002h\u00055\u0014\u0011OA\n\u001b\t\tIGC\u0002\u0002l\u001d\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\ty'!\u001b\u0003\u000fQ\u0013\u0018.Z'baB!Q\"\u0011\u0012)\u0011%\t)(a\u0016!\u0002\u0013\t)'\u0001\u000bd_:tWm\u0019;j_:\u0004vn\u001c7DC\u000eDW\r\t\u0005\t\u0003s\n9\u0006\"\u0001\u0002|\u0005)\u0011\r\u001d9msR)!(! \u0002\n\"A\u0011qPA<\u0001\u0004\t\t)\u0001\u0002tGB!\u00111QAC\u001b\u0005I\u0012bAAD3\ta1\u000b]1sW\u000e{g\u000e^3yi\"1q&a\u001eA\u0002AB\u0001\"!$\u0002X\u0011\u0005\u0011qR\u0001\u0012O\u0016$8i\u001c8oK\u000e$\u0018n\u001c8Q_>dGCBA\n\u0003#\u000b\u0019\n\u0003\u0004\"\u0003\u0017\u0003\rA\t\u0005\b\u0003+\u000bY\t1\u0001)\u0003\t!7\u000f\u0003\u0006\u0002\u001a\u0006]\u0013\u0011!C\u0005\u00037\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0014\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*\u0019\u00111\u00150\u0002\t1\fgnZ\u0005\u0005\u0003O\u000b\tK\u0001\u0004PE*,7\r\u001e")
public class ClickhouseConnector
implements Serializable,
Logging {
    private final ConnectorConf conf;
    private final ClickHouseDataSource initDataSource;
    private final String cluster;
    private final /* synthetic */ Tuple2 x$1;
    private final Map<Object, Seq<InetAddress>> dataSource;
    private final ClickHouseDataSource theDataSource;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static ConnectionPooledDBUrl getConnectionPool(ConnectorConf connectorConf, ClickHouseDataSource clickHouseDataSource) {
        return ClickhouseConnector$.MODULE$.getConnectionPool(connectorConf, clickHouseDataSource);
    }

    public static ClickhouseConnector apply(SparkContext sparkContext, String string) {
        return ClickhouseConnector$.MODULE$.apply(sparkContext, string);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Map<Object, Seq<InetAddress>> dataSource() {
        return this.dataSource;
    }

    public ClickHouseDataSource theDataSource() {
        return this.theDataSource;
    }

    public TableScanner execute(ClickhousePartition partition, String query) {
        try {
            return this.executeStatement((Iterator<String>)((IterableLike)partition.endpoints().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(InetAddress x$2) {
                    return x$2.getHostAddress();
                }
            }, Iterable$.MODULE$.canBuildFrom())).iterator(), PartitionQuery$.MODULE$.queryForPartition(query, partition), ClickhouseConnector$.MODULE$.getConnectionPool(this.conf, this.theDataSource()));
        }
        catch (ShardUnavailableException shardUnavailableException) {
            throw new ShardUnavailableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"all servers for shard (", ") are not accessible: (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partition.shardId()), ((TraversableOnce)partition.endpoints().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(InetAddress x$3) {
                    return x$3.getHostAddress();
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",")})), shardUnavailableException);
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TableScanner executeStatement(Iterator<String> shardNodes, String query, ConnectionPooledDBUrl cp) {
        while (true) {
            if (!shardNodes.hasNext()) {
                throw new ShardUnavailableException(ShardUnavailableException$.MODULE$.apply$default$1(), ShardUnavailableException$.MODULE$.apply$default$2());
            }
            String shard = (String)shardNodes.next();
            try {
                JdbcConnection jdbc = cp.getConnection(shard);
                PreparedStatement statement = jdbc.connection().prepareStatement(query);
                return new TableScanner(cp, jdbc, statement);
                {
                    catch (Throwable throwable) {
                        void var9_6;
                        cp.releaseConnection((JdbcConnection)var9_6);
                        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to execute query to Clickhouse: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query})), throwable);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                void var5_4;
                this.logWarning((Function0<String>)new Serializable(this, (String)var5_4){
                    public static final long serialVersionUID = 0L;
                    private final String shard$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception with execute statement, shard_node: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.shard$1}));
                    }
                    {
                        this.shard$1 = shard$1;
                    }
                }, noSuchElementException);
                continue;
            }
            catch (Throwable throwable) {
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to open connection to Clickhouse at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{shard})), throwable);
            }
            break;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    private List<Tuple3<Object, String[], String[]>> getClusterMetadata() {
        String query = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select shard_num, groupArray(host_name) as names, groupArray(host_address) as addresses from system.clusters "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"where cluster = '", "' group by shard_num"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cluster}))).toString();
        return this.executeStatement((Iterator<String>)this.initDataSource.value().keys().iterator(), query, ClickhouseConnector$.MODULE$.getConnectionPool(this.conf, this.initDataSource)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, String[], String[]> apply(ResultSet rs) {
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)rs.getInt("shard_num")), (Object)((String[])rs.getArray("names").getArray()), (Object)((String[])rs.getArray("addresses").getArray()));
            }
        }).toList();
    }

    public Option<Object> io$clickhouse$spark$connector$ClickhouseConnector$$detectShard(List<Tuple3<Object, String[], String[]>> clusterMetadata, String host) {
        return clusterMetadata.find((Function1)new Serializable(this, host){
            public static final long serialVersionUID = 0L;
            private final String host$1;

            public final boolean apply(Tuple3<Object, String[], String[]> v) {
                return Predef$.MODULE$.refArrayOps((Object[])v._2()).contains((Object)this.host$1) || Predef$.MODULE$.refArrayOps((Object[])v._3()).contains((Object)this.host$1);
            }
            {
                this.host$1 = host$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple3<Object, String[], String[]> x$4) {
                return BoxesRunTime.unboxToInt((Object)x$4._1());
            }
        });
    }

    private Tuple2<Map<Object, Seq<InetAddress>>, ClickHouseDataSource> makeDataSource() {
        Tuple2 tuple2;
        List<Tuple3<Object, String[], String[]>> clusterMeta = this.getClusterMetadata();
        if (this.conf.clickhouseAutoDiscoveryEnable()) {
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "cluster auto-discovery enabled";
                }
            });
            ClickHouseDataSource newDataSource = ClickHouseDataSource$.MODULE$.apply((Iterable<String>)((Iterable)clusterMeta.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayOps<String> apply(Tuple3<Object, String[], String[]> x$7) {
                    return Predef$.MODULE$.refArrayOps((Object[])x$7._3());
                }
            }, List$.MODULE$.canBuildFrom())), this.conf.clickhousePortDefault(), this.initDataSource.database());
            Map ds = ((TraversableOnce)clusterMeta.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, List<InetAddress>> apply(Tuple3<Object, String[], String[]> v) {
                    return new Tuple2(v._1(), (Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])v._3()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final InetAddress apply(String m) {
                            return InetAddress.getByName(m);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InetAddress.class)))).toList());
                }
            }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            tuple2 = new Tuple2((Object)ds, (Object)newDataSource);
        } else {
            Map ds = (Map)((TraversableLike)((TraversableLike)((TraversableLike)this.initDataSource.value().keys().map((Function1)new Serializable(this, clusterMeta){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClickhouseConnector $outer;
                private final List clusterMeta$1;

                public final Tuple2<Option<Object>, String> apply(String v) {
                    return new Tuple2(this.$outer.io$clickhouse$spark$connector$ClickhouseConnector$$detectShard((List<Tuple3<Object, String[], String[]>>)this.clusterMeta$1, v), (Object)v);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.clusterMeta$1 = clusterMeta$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Option<Object>, String> x$5) {
                    return ((Option)x$5._1()).isDefined();
                }
            })).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, String> apply(Tuple2<Option<Object>, String> v) {
                    return new Tuple2(((Option)v._1()).get(), v._2());
                }
            }, Iterable$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, String> x$6) {
                    return x$6._1$mcI$sp();
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, List<InetAddress>> apply(Tuple2<Object, Iterable<Tuple2<Object, String>>> v) {
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()), (Object)((TraversableOnce)((TraversableLike)v._2()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final InetAddress apply(Tuple2<Object, String> m) {
                            return InetAddress.getByName((String)m._2());
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toList());
                }
            }, Map$.MODULE$.canBuildFrom());
            tuple2 = new Tuple2((Object)ds, (Object)this.initDataSource);
        }
        return tuple2;
    }

    public ClickhouseConnector(ConnectorConf conf, ClickHouseDataSource initDataSource, String cluster) {
        this.conf = conf;
        this.initDataSource = initDataSource;
        this.cluster = cluster;
        Logging.class.$init$((Logging)this);
        Tuple2<Map<Object, Seq<InetAddress>>, ClickHouseDataSource> tuple2 = this.makeDataSource();
        if (tuple2 != null) {
            Map dataSource = (Map)tuple2._1();
            ClickHouseDataSource theDataSource = (ClickHouseDataSource)tuple2._2();
            if (dataSource != null) {
                Map map = dataSource;
                if (theDataSource != null) {
                    Tuple2 tuple22;
                    ClickHouseDataSource clickHouseDataSource = theDataSource;
                    this.x$1 = tuple22 = new Tuple2((Object)map, (Object)clickHouseDataSource);
                    this.dataSource = (Map)this.x$1._1();
                    this.theDataSource = (ClickHouseDataSource)this.x$1._2();
                    return;
                }
            }
        }
        throw new MatchError(tuple2);
    }
}

