/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaBaichuanAsoQueryResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlibabaBaichuanAsoQueryRequest
extends BaseTaobaoRequest<AlibabaBaichuanAsoQueryResponse> {
    private String appId;
    private Long appOs;
    private String deviceInfoList;

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppOs(Long appOs) {
        this.appOs = appOs;
    }

    public Long getAppOs() {
        return this.appOs;
    }

    public void setDeviceInfoList(String deviceInfoList) {
        this.deviceInfoList = deviceInfoList;
    }

    public void setDeviceInfoList(List<ASODeviceInfoDO> deviceInfoList) {
        this.deviceInfoList = new JSONWriter(false, true).write(deviceInfoList);
    }

    public String getDeviceInfoList() {
        return this.deviceInfoList;
    }

    @Override
    public String getApiMethodName() {
        return "alibaba.baichuan.aso.query";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("app_id", this.appId);
        txtParams.put("app_os", (Object)this.appOs);
        txtParams.put("device_info_list", this.deviceInfoList);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<AlibabaBaichuanAsoQueryResponse> getResponseClass() {
        return AlibabaBaichuanAsoQueryResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.appId, "appId");
        RequestCheckUtils.checkNotEmpty(this.appOs, "appOs");
        RequestCheckUtils.checkObjectMaxListSize(this.deviceInfoList, 20, "deviceInfoList");
    }

    public static class ASODeviceInfoDO
    extends TaobaoObject {
        private static final long serialVersionUID = 7413936946679414293L;
        @ApiField(value="idfa")
        private String idfa;
        @ApiField(value="imei")
        private String imei;
        @ApiField(value="imsi")
        private String imsi;

        public String getIdfa() {
            return this.idfa;
        }

        public void setIdfa(String idfa) {
            this.idfa = idfa;
        }

        public String getImei() {
            return this.imei;
        }

        public void setImei(String imei) {
            this.imei = imei;
        }

        public String getImsi() {
            return this.imsi;
        }

        public void setImsi(String imsi) {
            this.imsi = imsi;
        }
    }
}

