/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api;

import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.internal.cluster.ClusterManager;
import com.taobao.api.internal.cluster.DnsConfig;
import com.taobao.api.internal.feature.ClusterFeature;
import com.taobao.api.internal.util.TaobaoHashMap;

public class ClusterTaobaoClient
extends DefaultTaobaoClient {
    private ClusterFeature feature;

    private void initFeature() {
        this.feature = new ClusterFeature(){};
        this.feature.init(this);
    }

    public ClusterTaobaoClient(String serverUrl, String appKey, String appSecret) throws ApiException {
        super(serverUrl, appKey, appSecret);
        this.initFeature();
    }

    public ClusterTaobaoClient(String serverUrl, String appKey, String appSecret, String format) throws ApiException {
        super(serverUrl, appKey, appSecret, format);
        this.initFeature();
    }

    public ClusterTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) throws ApiException {
        super(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout);
        this.initFeature();
    }

    public ClusterTaobaoClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) throws ApiException {
        super(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout, signMethod);
        this.initFeature();
    }

    public String getServerUrl(String serverUrl, String apiName, String session, TaobaoHashMap appParams) {
        DnsConfig dnsConfig = ClusterManager.GetDnsConfigFromCache();
        if (dnsConfig == null) {
            return serverUrl;
        }
        return dnsConfig.getBestVipUrl(serverUrl, apiName, session, appParams);
    }

    public String getSdkVersion() {
        return "top-sdk-java-cluster-20210727";
    }
}

