#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file  : adserver_install_list.sh
# @author: rongpei
# @date  : 17-04-27
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

date_path=$(date -d "$ScheduleTime 1 days ago" "+%Y/%m/%d")
old_date_path=$(date -d "$ScheduleTime 2 days ago" "+%Y/%m/%d")
TASK_DATE="$(date -d "$ScheduleTime 1 days ago" "+%Y-%m-%d")"
year=${date_path:0:4}
month=${date_path:5:2}
day=${date_path:8:2}

INPUT_TODAY_ADN="${TMP_ADSERVER_PACKAGE_PATH}/${date_path}"
INPUT_LOG_DATE_ADN="$DM_INSTALL_LIST/${old_date_path}/adserver"
CAMPAIGN_TAG_OUTPUT="$DM_INSTALL_LIST/$date_path/adserver"
exit 0
hadoop fs -rm -r "$CAMPAIGN_TAG_OUTPUT/"
REDUCE_NUM=$(calculate_reduce_num "${INPUT_TODAY_ADN};${INPUT_LOG_DATE_ADN}")
check_await "${INPUT_LOG_DATE_ADN}/_SUCCESS"

hadoop jar ../${JAR} mobvista.dmp.datasource.packagelist.mapreduce.MergePackageName \
     -Dtask.date="$TASK_DATE" -Dmapreduce.job.reduces=${REDUCE_NUM} \
    "$INPUT_TODAY_ADN" "$INPUT_LOG_DATE_ADN"   "$CAMPAIGN_TAG_OUTPUT"  || exit 1


mount_partition "dm_install_list" "year='$year', month='$month', day='$day', business='adserver'" "$CAMPAIGN_TAG_OUTPUT" || exit 1

echo "[merge_package_name End!]"