#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author  :fengliang
# @revision: 2017-11-16
# @desc :  将当天3s install用户添加到ods_dmp_user_info表
# # # # # # # # # # # # # # # # # # # # # #

source ../../dmp_env.sh

today=${ScheduleTime:-$1}
dt=$(date +"%Y%m%d" -d "-1 day $today")
date=$(date +"%Y-%m-%d" -d "-1 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")
old_path=$(date +%Y/%m/%d -d "-2 day $today")
expire_date=$(date +%Y%m%d -d "-6 day $today")
expire_path=$(date +%Y/%m/%d -d "-6 day $today")

business_name="adn_request"
daily_path="${MDS_ADN_SDK_REQUEST_DAILY}/$date_path"
age_path="${AGE_CALC_DEVICE}/$date_path"
gender_path="${GENDER_CALC_DEVICE}/$date_path"
old_total_path="${ODS_DMP_USER_INFO}/$old_path/${business_name}"
OUTPUT_PATH="${ODS_DMP_USER_INFO}/$date_path/${business_name}"
unmount_path="${ODS_DMP_USER_INFO}/$expire_path/${business_name}"

coalesce=`calculate_reduce_num "${old_total_path};${daily_path}"`
check_await "${old_total_path}/_SUCCESS"
# check_await "${age_path}/_SUCCESS"
# check_await "${gender_path}/_SUCCESS"

#userInfoJob Parameter: LOG_TIME、dailyPath、dailyFormat、dailyDidIndex、dailyDidTypeIndex、dailyPltIndex、dailyCountryIndex、
# agePath、genderPath、totalPath、outputPath、coalesce、jar、exeNum、parallelism
userInfoJob "$date" "$daily_path" "rcfile" "0" "1" "2" "6" "$age_path" "$gender_path" "$old_total_path" "$OUTPUT_PATH" $coalesce "../../${JAR}"  80 400

mount_partition "ods_dmp_user_info" "dt='${dt}', business='${business_name}'" "$OUTPUT_PATH"
mount_partition "ods_dmp_user_info" "dt='${dt}', business='adn_install'" "$OUTPUT_PATH"


unmount_partition "ods_dmp_user_info" "dt='${expire_date}', business='${business_name}'" "$unmount_path"
unmount_partition "ods_dmp_user_info" "dt='${expire_date}', business='adn_install'" "$unmount_path"