#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # # 
# @file  : adn_interest_click.sh
# @author: houying
# @date  : 16-10-17
# # # # # # # # # # # # # # # # # # # # # # 

source ../../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

check_await "$APP_TAG_PATH/$year/$month/$day/_SUCCESS"

INPUT_INSTALL_PATH="${DM_INSTALL_LIST}_v1/$year/$month/$day/adn_request_sdk"
INPUT_APP_TAG_PATH="$APP_TAG_PATH/${year}/${month}/${day}/"
OUTPUT="$DM_INTEREST_PATH/$year/$month/$day/adn_request_sdk"

hadoop fs -rm -r "$OUTPUT"

REDUCE_NUM=$(calculate_reduce_num "$INPUT_INSTALL_PATH")

hadoop jar ../../${JAR} mobvista.dmp.common.InterestDeviceDistinctMR \
        -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
        -Dmapreduce.map.memory.mb=4096 \
        -Dmapreduce.map.java.opts=-Xmx2458m \
        -Dmapreduce.reduce.memory.mb=4096 \
        -Dmapreduce.reduce.java.opts=-Xmx2458m \
        -Dmapreduce.job.reduces=${REDUCE_NUM} \
        "$INPUT_APP_TAG_PATH/part-r-00000" "$INPUT_INSTALL_PATH" "$OUTPUT" "adn request interest job"

if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "dm_interest_tag" "year='$year', month='$month', day='$day', business='adn_request_sdk'" "$OUTPUT" || exit 1

echo "[Adn Tag Total End!]"
