set  hive.exec.dynamic.partition.mode=nonstrict;
set  hive.exec.dynamic.partition=true;
set mapred.max.split.size=536870912;
set mapred.min.split.size.per.node=536870912;
set mapred.min.split.size.per.rack=536870912;
set mapreduce.map.memory.mb=4000;
set mapreduce.map.java.opts=-Xmx3000m;
set mapreduce.reduce.memory.mb=3072;
set mapreduce.reduce.java.opts=-Xmx2458m;
set hive.jobname.length=100;


insert overwrite table dwh.gdt_data partition(day='${dt_today}',category='227229_oppo_package',business='imei_append')
select t2.device_id from
(select device_id from dwh.dm_install_list_v2_tmp_deviceid where dt='${dt_yesterday}'  and device_type='227229_imei') t1
right join
(select device_id from dwh.dm_install_list_v2_tmp_deviceid where dt='${dt_today}'  and device_type='227229_imei') t2
on t1.device_id=t2.device_id
where t1.device_id is null ;

insert overwrite table dwh.gdt_data partition(day='${dt_today}',category='227229_oppo_package',business='imeimd5_append')
select t2.device_id from
(select device_id from dwh.dm_install_list_v2_tmp_deviceid where dt='${dt_yesterday}'  and device_type='227229_imeimd5') t1
right join
(select device_id from dwh.dm_install_list_v2_tmp_deviceid where dt='${dt_today}'  and device_type='227229_imeimd5') t2
on t1.device_id=t2.device_id
where t1.device_id is null ;


insert overwrite table dwh.gdt_data partition(day='${dt_today}',category='227229_oppo_package',business='imei_delete')
select t1.device_id from
(select device_id from dwh.dm_install_list_v2_tmp_deviceid where dt='${dt_yesterday}'  and device_type='227229_imei') t1
left join
(select device_id from dwh.dm_install_list_v2_tmp_deviceid where dt='${dt_today}'  and device_type='227229_imei') t2
on t1.device_id=t2.device_id
where t2.device_id is null ;

insert overwrite table dwh.gdt_data partition(day='${dt_today}',category='227229_oppo_package',business='imeimd5_delete')
select t1.device_id from
(select device_id from dwh.dm_install_list_v2_tmp_deviceid where dt='${dt_yesterday}'  and device_type='227229_imeimd5') t1
left join
(select device_id from dwh.dm_install_list_v2_tmp_deviceid where dt='${dt_today}'  and device_type='227229_imeimd5') t2
on t1.device_id=t2.device_id
where t2.device_id is null ;

