#!/usr/bin/env bash

source ../dmp_env.sh

dt_slash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_today=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")

OUTPUT_PATH01="${TMP_DEVICEID}/${dt_slash_today}/other_data/227229_imei"
OUTPUT_PATH02="${TMP_DEVICEID}/${dt_slash_today}/other_data/227229_imeimd5"

ALI_USER_TO_3S_TOUTIAO_RES_PATH="${ALI_USERINFO_TO_3S_TOUTIAO_PATH}/${dt_slash_today}"

rm -rf totiao_H_19
mkdir totiao_H_19
cd totiao_H_19
#推头条数据
hadoop fs -test -e ${ALI_USER_TO_3S_TOUTIAO_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USER_TO_3S_TOUTIAO_RES_PATH}
fi

#H_19_imei
hadoop fs -text  ${OUTPUT_PATH01}/* > imei.totiaocsv
split -b 55m  imei.totiaocsv  -d -a 2 H_19_imei_
for new_path in $(ls H_19_imei_*)
do
   echo ${new_path}
   device_id="imei"
   echo $device_id
   java -cp ../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${new_path}_1 ${device_id}
   zip ${new_path}_1.zip ${new_path}_1
   hadoop fs -put ${new_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
   rm -f  ${new_path}*
done
rm -f imei.totiaocsv

#H_19_imeimd5
hadoop fs -text  ${OUTPUT_PATH02}/* > imeimd5.totiaocsv
split -b 55m  imeimd5.totiaocsv  -d -a 2 H_19_imeimd5_
for new_path in $(ls H_19_imeimd5_*)
do
   echo ${new_path}
   device_id="imeimd5"
   echo $device_id
   java -cp ../../${JAR} mobvista.dmp.datasource.toutiao.dmp.TouTiaoUtil  ${new_path} ${new_path}_1 ${device_id}
   zip ${new_path}_1.zip ${new_path}_1
   hadoop fs -put ${new_path}_1.zip "${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/"
   rm -f  ${new_path}*
done
rm -f imeimd5.totiaocsv


#hadoop fs -touchz ${ALI_USER_TO_3S_TOUTIAO_RES_PATH}/_SUCCESS
rm -rf totiao_H_19
