#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_oneday_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime" +"%Y/%m/%d")
dt_dash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y-%m-%d")


#append  拉新
LAXIN_0_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin_delete/laxin_0"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin_delete', business='laxin_0'" "${LAXIN_0_DELETE_SYS_TO3S_PATH}"

LAXIN_1_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin_delete/laxin_1"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin_delete', business='laxin_1'" "${LAXIN_1_DELETE_SYS_TO3S_PATH}"

LAXIN_2_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin_delete/laxin_2"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin_delete', business='laxin_2'" "${LAXIN_2_DELETE_SYS_TO3S_PATH}"


#append  拉活
LAHUO_0_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin_delete/lahuo_0"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin_delete', business='lahuo_0'" "${LAHUO_0_DELETE_SYS_TO3S_PATH}"

LAHUO_1_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin_delete/lahuo_1"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin_delete', business='lahuo_1'" "${LAHUO_1_DELETE_SYS_TO3S_PATH}"

LAHUO_2_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin_delete/lahuo_2"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin_delete', business='lahuo_2'" "${LAHUO_2_DELETE_SYS_TO3S_PATH}"

LAHUO_3_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin_delete/lahuo_3"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin_delete', business='lahuo_3'" "${LAHUO_3_DELETE_SYS_TO3S_PATH}"

LAHUO_4_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin_delete/lahuo_4"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin_delete', business='lahuo_4'" "${LAHUO_4_DELETE_SYS_TO3S_PATH}"

LAHUO_5_DELETE_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/alipay_lahuo_laxin_delete/lahuo_5"
mount_partition "gdt_data" "day='${dt_today}', category='alipay_lahuo_laxin_delete', business='lahuo_5'" "${LAHUO_5_DELETE_SYS_TO3S_PATH}"



HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}     -hivevar  dt_yesterday ${dt_yesterday}  -f alipay_lahuo_laxin_delete_data_to_guangdiantong.sql

if [ $? -ne 0 ];then
  exit 255
fi

rm -rf alipay_delete_guangdiantong
mkdir alipay_delete_guangdiantong
cd alipay_delete_guangdiantong



ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH="${ALI_USERINFO_TO_3S_ALIPAY_DELETE_PATH}/${dt_slash_today}"
hadoop fs -rm -r "${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}"


#支付宝拉活拉新推广点通追加数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}
fi

#laxin
hadoop fs -text  ${LAXIN_0_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_0_HASH_IMEI_
for new_path in $(ls ALIPAY_0_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAXIN_1_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_1_HASH_IMEI_
for new_path in $(ls ALIPAY_1_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAXIN_2_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_2_HASH_IMEI_
for new_path in $(ls ALIPAY_2_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

#lahuo
hadoop fs -text  ${LAHUO_0_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_3_HASH_IMEI_
for new_path in $(ls ALIPAY_3_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAHUO_1_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_4_HASH_IMEI_
for new_path in $(ls ALIPAY_4_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAHUO_2_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_5_HASH_IMEI_
for new_path in $(ls ALIPAY_5_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAHUO_3_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_6_HASH_IMEI_
for new_path in $(ls ALIPAY_6_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAHUO_4_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_7_HASH_IMEI_
for new_path in $(ls ALIPAY_7_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${LAHUO_5_DELETE_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 ALIPAY_8_HASH_IMEI_
for new_path in $(ls ALIPAY_8_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv



hadoop fs -touchz ${ALI_USERINFO_TO_3S_ALIPAY_DELETE_RES_PATH}/_SUCCESS


rm -rf alipay_delete_guangdiantong
echo "good job~~"


