set  hive.exec.dynamic.partition.mode=nonstrict;
set  hive.exec.dynamic.partition=true;
set mapred.max.split.size=536870912;
set mapred.min.split.size.per.node=536870912;
set mapred.min.split.size.per.rack=536870912;
set mapreduce.map.memory.mb=4000;
set mapreduce.map.java.opts=-Xmx3000m;
set mapreduce.reduce.memory.mb=3072;
set mapreduce.reduce.java.opts=-Xmx2458m;
set hive.jobname.length=100;


insert overwrite table dwh.dm_install_list_v2 partition(dt='${dt_today}',business='kuaishou_foractivation')
     select device_id,'imeimd5' device_type,'android' platform,'com.kuaishou.rta_imei' package_name,'${update_date}' update_date
     from dwh.dm_install_list_v2_tmp_deviceid where dt='${dt_today}' and device_type='kuaishou_rta_imei'
     UNION
     select device_id,'oaidmd5' device_type,'android' platform,'com.kuaishou.rta_oaid' package_name,'${update_date}' update_date
     from dwh.dm_install_list_v2_tmp_deviceid where dt='${dt_today}' and device_type='kuaishou_rta_oaid';


insert into table dwh.dm_install_list_v2 partition(dt='${dt_today}',business='kuaishou_foractivation')
     select device_id,'imeimd5' device_type,'android' platform,'com.kuaishoujisu.rta_imei' package_name,'${update_date}' update_date
     from dwh.dm_install_list_v2_tmp_deviceid where dt='${dt_today}' and device_type='kuaishoujisu_rta_imei'
     UNION
     select device_id,'oaidmd5' device_type,'android' platform,'com.kuaishoujisu.rta_oaid' package_name,'${update_date}' update_date
     from dwh.dm_install_list_v2_tmp_deviceid where dt='${dt_today}' and device_type='kuaishoujisu_rta_oaid';