#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_oneday_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime" +"%Y/%m/%d")
dt_dash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y-%m-%d")

## 等待爱奇艺拉货设备入库dm_install_list_v2
DMP_INSTALL_LIST_OUTPUT_PATH="${DM_INSTALL_LIST}_v2/${dt_slash_today}/uc_activation"
check_await "${DMP_INSTALL_LIST_OUTPUT_PATH}/_SUCCESS"

#all
ALI_IMEI_0_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_0"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo', business='imei_0'" "${ALI_IMEI_0_UC_LAHUO_SYS_TO3S_PATH}"

ALI_IMEI_1_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_1"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo', business='imei_1'" "${ALI_IMEI_1_UC_LAHUO_SYS_TO3S_PATH}"

ALI_IMEI_2_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_2"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo', business='imei_2'" "${ALI_IMEI_2_UC_LAHUO_SYS_TO3S_PATH}"

ALI_IMEI_3_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_3"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo', business='imei_3'" "${ALI_IMEI_3_UC_LAHUO_SYS_TO3S_PATH}"

ALI_IMEI_4_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_4"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo', business='imei_4'" "${ALI_IMEI_4_UC_LAHUO_SYS_TO3S_PATH}"

ALI_IMEI_5_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_5"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo', business='imei_5'" "${ALI_IMEI_5_UC_LAHUO_SYS_TO3S_PATH}"


ALI_OAID_2_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_2"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo', business='oaid_2'" "${ALI_OAID_2_UC_LAHUO_SYS_TO3S_PATH}"

ALI_OAID_3_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_3"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo', business='oaid_3'" "${ALI_OAID_3_UC_LAHUO_SYS_TO3S_PATH}"

ALI_OAID_5_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_5"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo', business='oaid_5'" "${ALI_OAID_5_UC_LAHUO_SYS_TO3S_PATH}"

ALI_OAID_6_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_6"
mount_partition "gdt_data" "day='${dt_today}', category='uc_lahuo', business='oaid_6'" "${ALI_OAID_6_UC_LAHUO_SYS_TO3S_PATH}"

HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}     -hivevar  dt_yesterday ${dt_yesterday}  -f ali_extract_uc_lahuo_data_to_dmp.sql

if [ $? -ne 0 ];then
  exit 255
fi

#这个标签作为下游  H_22~H_31  数据包推送头条 脚本程序开始运行标志
hadoop fs -touchz ${ALI_OAID_3_UC_LAHUO_SYS_TO3S_PATH}/_SUCCESS

echo "good job~~"


