#!/usr/bin/env bash

source ../../dmp_env.sh
source ././../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_oneday_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime" +"%Y/%m/%d")
dt_dash_today=$(date -d "$ScheduleTime 2 days ago" +"%Y-%m-%d")


#all
ALI_IMEI_0_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_0"

ALI_IMEI_1_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_1"

ALI_IMEI_2_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_2"

ALI_IMEI_3_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_3"

ALI_IMEI_4_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_4"

ALI_IMEI_5_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/imei_5"

#ALI_OAID_0_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_0"
#
#ALI_OAID_1_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_1"

ALI_OAID_2_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_2"

ALI_OAID_3_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_3"

# ALI_OAID_4_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_4"

ALI_OAID_5_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_5"

ALI_OAID_6_UC_LAHUO_SYS_TO3S_PATH="$GDT_DATA/${dt_slash_today}/uc_lahuo/oaid_6"

rm -rf uc_guangdiantong
mkdir uc_guangdiantong
cd uc_guangdiantong

ALI_USERINFO_TO_3S_UC_RES_PATH="${ALI_USERINFO_TO_3S_UC_PATH}/${dt_slash_today}"
hadoop fs -rm -r "${ALI_USERINFO_TO_3S_UC_RES_PATH}"
#uc拉活数据推广点通数据
hadoop fs -test -e ${ALI_USERINFO_TO_3S_UC_RES_PATH}
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p ${ALI_USERINFO_TO_3S_UC_RES_PATH}
fi

#imei
hadoop fs -text  ${ALI_IMEI_0_UC_LAHUO_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_0_HASH_IMEI_
for new_path in $(ls UC_0_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_IMEI_1_UC_LAHUO_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_1_HASH_IMEI_
for new_path in $(ls UC_1_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_IMEI_2_UC_LAHUO_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_2_HASH_IMEI_
for new_path in $(ls UC_2_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_IMEI_3_UC_LAHUO_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_3_HASH_IMEI_
for new_path in $(ls UC_3_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_IMEI_4_UC_LAHUO_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_4_HASH_IMEI_
for new_path in $(ls UC_4_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_IMEI_5_UC_LAHUO_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_5_HASH_IMEI_
for new_path in $(ls UC_5_HASH_IMEI_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv
#oaid

hadoop fs -text  ${ALI_OAID_2_UC_LAHUO_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_2_HASH_OAID_
for new_path in $(ls UC_2_HASH_OAID_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_OAID_3_UC_LAHUO_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_3_HASH_OAID_
for new_path in $(ls UC_3_HASH_OAID_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_OAID_5_UC_LAHUO_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_5_HASH_OAID_
for new_path in $(ls UC_5_HASH_OAID_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

hadoop fs -text  ${ALI_OAID_6_UC_LAHUO_SYS_TO3S_PATH}/* > result.csv
split -b 160m  result.csv  -d -a 2 UC_6_HASH_OAID_
for new_path in $(ls UC_6_HASH_OAID_*)
  do
   zip ${new_path}.zip ${new_path}
   hadoop fs -put ${new_path}.zip "${ALI_USERINFO_TO_3S_UC_RES_PATH}/"
   rm -f ${new_path}*
done
rm -f  result.csv

#hadoop fs -touchz ${ALI_USERINFO_TO_3S_UC_RES_PATH}/_SUCCESS


rm -rf uc_guangdiantong
echo "good job~~"


