#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author  :fengliang
# @revision: 2018-04-24
# @desc :  将产品新给的标签信息合入到标签表
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

date=$(date +"%Y-%m-%d" -d "-1 day $ScheduleTime")
date_path=$(date +%Y/%m/%d -d "-1 day $ScheduleTime")
output_path="${DIM_CAMPAIGN_TAGS_PATH}/${date_path}"

if [ $# -lt 1 ];then
   echo "Usage: <newPath>"
   exit 255
fi

new_path="${1}"
hadoop fs -test -e $new_path
if [ $? -ne 0 ]; then
    echo "file $new_path not exist"
    exit 255
fi

hadoop fs -rmr $output_path
spark-submit --class mobvista.dmp.datasource.newtag.ImportCampaignTags \
     --conf spark.sql.shuffle.partitions=10 \
     --conf spark.default.parallelism=5 \
     --files ${HIVE_SITE_PATH} \
     --master yarn --deploy-mode cluster --executor-memory 8g --driver-memory 4g  --executor-cores 4  --num-executors 5 \
    ../${JAR} -newPath ${new_path} -output $output_path

if [ $? -ne 0 ]; then
    exit 255
fi

hive_cmd "use dwh;alter table dim_campaign_tags set location '${output_path}';"
if [ $? -ne 0 ]; then
    exit 255
fi