#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author  :fengliang
# @revision: 2018-04-19
# @desc :  新标签体系匹配标签
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")
expire_date=$(date +%Y%m%d -d "-4 day $today")
expire_date_path=$(date +%Y/%m/%d -d "-4 day $today")

source='manual'
business='clever'
storeSource="store"
output_path="${DM_DEVICE_TAG_PATH}/${date_path}/${source}/${business}"
store_output_path="${DM_DEVICE_TAG_PATH}/${date_path}/${storeSource}/${business}"
expire_path="${DM_DEVICE_TAG_PATH}/${expire_date_path}/${source}/${business}"
expire_store_path="${DM_DEVICE_TAG_PATH}/${expire_date_path}/${storeSource}/${business}"
input_path="${DM_INSTALL_LIST}_v2/${date_path}/${business}"
app_tag_path="${APP_TAG_PATH}/${date_path}"

check_await "${app_tag_path}/_SUCCESS"
check_await "${input_path}/_SUCCESS"

hadoop fs -rmr ${output_path}
hadoop fs -rmr ${store_output_path}


spark-submit --class mobvista.dmp.datasource.newtag.MatchInterestTag \
     --conf spark.sql.shuffle.partitions=100 \
     --files ${HIVE_SITE_PATH} \
     --jars /data/hadoop-alternative/hive/auxlib/Common-SerDe-1.0-SNAPSHOT.jar \
     --master yarn --deploy-mode cluster --executor-memory 8g --driver-memory 6g  --executor-cores 3  --num-executors 20 \
     ../${JAR} \
     -date ${date} -manualOutput ${output_path} -business ${business} -storeOutput ${store_output_path} -coalesce 100
if [ $? -ne 0 ]; then
    exit 255
fi



# 挂载分区
mount_partition "dmp_device_tag" "dt='${date}', source='${source}', business='${business}'" "${output_path}"
mount_partition "dmp_device_tag" "dt='${date}', source='${storeSource}', business='${business}'" "${store_output_path}"

# 补写成功标志
hadoop fs -touchz ${store_output_path}/_SUCCESS

# 删除过期的分区及删除对应路径
unmount_partition "dmp_device_tag" "dt='${expire_date}', source='${source}', business='${business}'" "${expire_path}"
unmount_partition "dmp_device_tag" "dt='${expire_date}', source='${storeSource}', business='${business}'" "${expire_store_path}"